<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

// No direct access.
defined('_JEXEC') or die;

/**
 * Class nge article.
 * @since 1.0
 */
class NgeArticleHelper{
	/**
	 * Method to create a Joomla article
	 * @since 1.0
	 * @param String title
	 * @param String category
	 * @return object (article information) or false if not created
	 */
	public static function createArticle($data){
		$articleTable = JTable::getInstance("content");
		$dataToStore = self::updateData($data);
		
		$articleTable->bind($dataToStore);
		
		if ($articleTable->check()){
			$articleTable->store();
			return $articleTable;
		}else {
			return false;
		}
	}
	
	private static function updateData($data){
		$updatedata = $data;
		$table = JTable::getInstance("content");
		
		if (JFactory::getConfig()->get('unicodeslugs') == 1){
			$alias = JFilterOutput::stringURLUnicodeSlug($data['title']);
		}else{
			$alias = JFilterOutput::stringURLSafe($data['title']);
		}
		
		if(!isset($data["catid"])){
			return false;
		}else{
			$catid = ($data["catid"] != "") ? $data["catid"] : 2;
		}
		
		// Check: alias already exists in db and add "-2", "-3", ... if yes:
		while ($table->load(array('alias' => $alias, 'catid' => $catid))) {
			$alias = JString::increment( $alias, 'dash');
		}
		
		$updatedata["alias"] = $alias;
		$updatedata["state"] = "1";
		$updatedata["publish_up"] = JFactory::getDate()->toSql();
		
		return $updatedata;	
	}
	
	public static function saveContent($id, $content){
		
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		if (trim($articleTable->fulltext) != '')
			$articleTable->fulltext = $content;
		else
			$articleTable->introtext = $content;
		
		//if ($articleTable->check()){
			return $articleTable->store();
		//}else {
		//	return false;
		//}		
		//TODO Trigger onSave
	}
    
    /**
     * NgeArticleHelper::saveSeo()
     * save article SEO from mainbar
     * @param mixed $id
     * @param mixed $article_seo
     * @return
     */
    public static function saveSeo($id, $article_seo) {
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
        
		$articleTable->title = $article_seo['title'] ;
		$articleTable->metakey = $article_seo['metakey'] ;
		$articleTable->metadesc = $article_seo['metadesc'] ;
        

		
		//if ($articleTable->check()){
			return $articleTable->store();
        
    }
	
	/**
	 * Method to get a Joomla article information
	 * @since 1.0
	 * @param id
	 * @return object (article information) or false if not created
	 */
	public static function getArticle($id){
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		return $articleTable;
	}
	
	/**
	 * Method to get a new position Ref in an article
	 *
	 * @param   integer  $pk  The id of the primary key of the article.
	 *
	 * @return  string  new Position string
	 *
	 */
	public static function getNewPosition($pk)
	{
	    $db	= JFactory::getDBO();
	    $query	= $db->getQuery(true)
	    ->select($db->quoteName('alias'))
	    ->from($db->quoteName('#__content'))
	    ->where($db->quoteName('id') . ' = ' . (int) $pk);
	    $db->setQuery($query);
	    $result = $db->loadObject();
	    if ($result)
		return $result->alias.'-'.rand(1000, 9999);
	    else
		return rand(100000, 999999);
	}
	
	/**
	 * Method to render html or tags for a position in the article
	 *
	 * @param   string  $position  The name of the position
	 *
	 * @return  string  new Position string
	 *
	 */
	public static function renderPosition($position){
	 return '{loadposition '.$position.'}';   
	}
		
	public static function render($pk){
		$article = NgeArticleDriver::load($pk);
		$result['callback'] = $article->introtext;
	}
}