var page = require('webpage').create(),
system = require('system'),
input,
width,
height;

if (system.args.length == 4) {
    input = system.args[1];
    width = system.args[2];
    height = system.args[3];

    page.onError = function(msg, trace) {
      /*prevent js errors from showing in page.content*/
      return;
    };

    page.open(input, function (status) {
        if (status !== 'success') {
            console.log('Unable to access network');
            phantom.exit();
        } else {
            window.setTimeout(function () {
                var svg = page.evaluate(function (width, height) {
                    var svgElement = jQuery("svg");
                    var currentSvg = svgElement.parent().html();
                    if(typeof currentSvg !== "undefined"){
                        svgElement.attr("width", width+"mm");
                        svgElement.attr("height", height+"mm");
                        return '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'+svgElement.parent().html();
                    }else{
                        return null;
                    }
                }, width, height);
                console.log(svg); /*highchart source*/
                
                phantom.exit();
            }, 2500);
        }
    });
}else{
    console.log('Try to pass some args when invoking this script!');
    phantom.exit();
}