var page = require('webpage').create(),
system = require('system'),
quality = '89',
inputUrl,
outputUrl,
outputFormat;

if (system.args.length >= 3) {
    inputUrl = system.args[1];
    outputUrl = system.args[2];
    outputFormat = (typeof system.args[3] !== "undefined") ? system.args[3] : "png";

    page.viewportSize = { width: 500, height: 20000 };
    page.open(inputUrl, function start(status) {
        if (status !== 'success') {
            console.log('Unable to access network');
            phantom.exit();
        } else {
            window.setTimeout(function () {
                var object = page.evaluate(function (outputFormat) {
                    var widgetElement = jQuery(".part");
                    var bodyElement = jQuery("body");
					
                    /*Specific to jpg format force background body to white. Default render in black*/
                    if(outputFormat === "jpg"){
                            backgroundColor = bodyElement.css('background-color');
                            if(typeof backgroundColor === "undefined" || backgroundColor === null || backgroundColor === "" || backgroundColor === "rgba(0, 0, 0, 0)"){
                                    jQuery('head').append('<style>body{background-color:#FFFFFF;}</style>');
                            }
                    }
					
                    widgetElement.css('display', 'inline-block');
                    
                    var pageWidth = bodyElement.width();
                    var widgetWidth = widgetElement.width();
                    var ratio = 1;
					
                    if(widgetWidth < pageWidth){
                        ratio = 500/widgetWidth;
                    }else if(widgetWidth > pageWidth){
                        ratio = 500/widgetWidth;
                    }
					
                    if(widgetElement.find(".highcharts-container").length > 0){
                        widgetElement.find(".highcharts-container").css({
                            'transform-origin': 'top left',
                            'transform': 'scale('+ratio+')',
                            '-webkit-transform-origin': 'top left',
                            '-webkit-transform': 'scale('+ratio+')'
                        });
                    }else{
                        widgetElement.css({
                            'transform-origin': 'top left',
                            'transform': 'scale('+ratio+')',
                            '-webkit-transform-origin': 'top left',
                            '-webkit-transform': 'scale('+ratio+')'
                        });
                    }
					
                    return {
                        pageWidth : pageWidth,
                        ratio : ratio,
                        widgetWidth : widgetWidth,
                        widgetHeight : widgetElement.height()
                    }
                }, outputFormat);

                page.viewportSize = { width: (object.widgetWidth*object.ratio), height: (object.widgetHeight*object.ratio)};
                //page.zoomFactor = object.ratio;
                page.render(outputUrl, {format: outputFormat, quality: quality});
                phantom.exit();
            }, 2500);
        }
    });
}else{
    console.log('Try to pass some args when invoking this script!');
    phantom.exit();
}