<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_banners
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_ADMINISTRATOR . 'components/com_banners/helpers/html');
JHtml::_('behavior.formvalidator');
JHtml::_('formbehavior.chosen', 'select');

JFactory::getDocument()->addScriptDeclaration('
	Joomla.submitbutton = function(task)
	{
		if (task == "client.cancel" || document.formvalidator.isValid(document.getElementById("client-form")))
		{
			Joomla.submitform(task, document.getElementById("client-form"));
		}
	};
');

$modal = JFactory::getApplication()->input->get('tmpl','') ? '&tmpl='.JFactory::getApplication()->input->get('tmpl') : '';

?>

<form action="<?php echo JRoute::_('index.php?option=com_arkeditor&view=category&layout=edit&id=' . (int) $this->item->id).$modal; ?>" method="post" name="adminForm" id="client-form" class="form-validate">
    <?php  echo str_replace('btn-wrapper', 'btn-wrapper btn-group', JToolBar::getInstance('toolbar')->render()); ?>
	<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', empty($this->item->id) ? JText::_('COM_BANNERS_NEW_CLIENT') : JText::_('COM_BANNERS_EDIT_CLIENT')); ?>
		<div class="row-fluid">
			<div class="span9">
				<?php
				echo $this->form->renderField('contact');
				echo $this->form->renderField('email');
				echo $this->form->renderField('purchase_type');
				echo $this->form->renderField('track_impressions');
				echo $this->form->renderField('track_clicks');
				echo $this->form->renderFieldset('extra');
				?>
			</div>
			<div class="span3">
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'metadata', JText::_('JGLOBAL_FIELDSET_METADATA_OPTIONS')); ?>
		<?php echo $this->form->renderFieldset('metadata'); ?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	</div>

	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>
