<?php

/**
 * This file is part of Nge
 *
 * @version     1.0
 * @package		Nge
 * @copyright	Copyright (C) 2014 TEATIS. All rights reserved.
 * @license		GNU/GPL, see LICENSE.txt
 * NextGenEditor is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses.
 *
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
if (!defined('DS'))
    define('DS', DIRECTORY_SEPARATOR);

class pkg_ngeInstallerScript {

    private $version = 0;

    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent) {

    }

    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent) {
	
    }

    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent) {
	
    }

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent) {
	
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent) {

	// update subscription_id in update_site table
	// get subscription_id if exist
	$subscriptionFile = JPATH_ADMINISTRATOR . 'components/com_nge/nge_subscription.json';
	$subscriptionId = '';

	if (file_exists($subscriptionFile)) {
	    $subscriptionJson = file_get_contents($subscriptionFile);
	    $subscriptionObject = json_decode($subscriptionJson);
	    $subscriptionId = $subscriptionObject->subscription_id;
	}

	$extra_query = '';
	if ($subscriptionId != '')
	    $extra_query = 'subscription_id=' . $subscriptionId;

	// update table
	$sql = sprintf('UPDATE #__update_sites SET extra_query="%s" 
    		WHERE update_site_id=(SELECT update_site_id FROM #__update_sites_extensions sie 
    		LEFT JOIN #__extensions ext ON sie.extension_id=ext.extension_id 
    		WHERE ext.element="pkg_nge")', $extra_query);
	$db = JFactory::getDBO();
	$db->setQuery($sql);
	$db->execute();

	// update com_nge params field
	$componentParams = JComponentHelper::getParams('com_nge');

	$subscriptionId = $componentParams->set('subscription_id', $subscriptionId);

	$sql = sprintf('UPDATE #__extensions SET params="%s" WHERE element="com_nge"', $componentParams->toString());

	//End of installation
	$parent->getParent()->setRedirectURL('index.php?option=com_nge&view=cpanel&layout=afterinstall');
    }

}
