<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

/**
 * Tags view class for the Tags package.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_tags
 * @since       3.1
 */
class NgeViewPlugins extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

	//	NgeHelper::addSubmenu('nge');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			NGE::message(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
        JHtmlSidebar::addEntry(JText::_( 'JEP_PLUGINS_PANEL' ), 'index.php?option=com_nge&view=cpanel',false);
        JHtmlSidebar::addEntry(JText::_( 'JEP_MANAGE_PLUGINS' ), 'index.php?option=com_nge&view=plugins',true);
        //JHtmlSidebar::addEntry(JText::_( 'JEP_INSTALL_PLUGIN' ), 'index.php?option=com_nge&view=install',false);


		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   3.1
	 */
	protected function addToolbar()
	{
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_NGE_MANAGER_NGE'), 'nge');
			JToolbarHelper::custom('install.add','new','',JText::_("JEP_ADD_NEW"),false);
			JToolbarHelper::custom('install.uninstall','remove','',JText::_("JEP_REMOVE"),true);



	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.lft' => JText::_('JGRID_HEADING_ORDERING'),
			'a.state' => JText::_('JSTATUS'),
			'p.title' => JText::_('JGLOBAL_TITLE'),
			'a.id' => JText::_('JGRID_HEADING_ID')
		);
	}
}
