<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
/**
 * View to edit
 */
class NgeViewPart extends JViewLegacy {

    protected $state;
    protected $item;
    protected $form;
    protected $params;
    protected $workshop;

    /**
     * Display the view
     */
    public function display($tpl = null) {

    	$jinput = JFactory::getApplication()->input;
    	$mode =					$jinput->get('mode', '', 'string');
    	$plname = 				$jinput->get('plname', '','string'); //Part library id
    	$pk = 					$jinput->get('pk', '', 'int'); //Existing part id
    	$includeLibraries =				$jinput->get('include_libraries', '1', 'int'); //Existing part id
    	$model = $this->getModel();
        
	//Language file for messages (warning/information)
        $lang = JFactory::getLanguage();
        $lang->load('com_nge_preview', JPATH_SITE);
                        
    	if ($plname != ''){ //Creation mode, part library id
    		$name = $plname;
    	}else if ($pk != '') //Modification mode, part id
    		$name = '['.$pk.']';
    
    	//If mode == edit, create, duplicate, we are in the config screen, in live preview, live params are in the url
    	//Otherwise, no url params, normal rendering => only database params
		
	//Warning. If values are json string object, decode them to save them as array.
	//Each array item can be modified by inlineediting.
	//Save thing in model part->save
        $keyArrayJson = NGE::recursive_array_search('ngejson::',$_REQUEST);
        if($keyArrayJson !== false){/*If value with json object string exist*/
            $_REQUEST = NGE::decode_json_string($_REQUEST, $keyArrayJson);
        }

    	if (($mode == 'edit') || ($mode == 'create') || ($mode == 'duplicate'))
    		$urlparams = json_encode($_REQUEST);
    	else
    		$urlparams = '';
	$renderingMode="preview";
	require_once NGEPATH_HELPERS . '/ngecontenthelper.php';	
	$result = $model->render($name, $renderingMode, $urlparams);
	//Load common scripts and stylesheets for the current part		
	//TOTO, scripts are always included, because of content.prepare call in the part model.
	if ($includeLibraries == '1'){ //Include libraries when first preview
	    $result = NgeContenthelper::renderScripts() . $result;
	    $result = NgeContenthelper::renderStyleSheets() . $result;
	}
	$this->partContent = $result;
	
        parent::display($tpl);
    }
}
