<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * WIDGET EDITING FIGARO
 */
// No direct access
defined('_JEXEC') or die;

require_once (JPATH_SITE.'/components/com_nge/parts/figaro/helpers/const.php');

$msg_error_html = "";
$array_error = array(
    1 => 'L\'email <strong>'.$this->user_email.'</strong> n\'existe pas dans l\'atelier Infographie. Merci de contacter l\'administrateur.',
    2 => "Aucun numéro de widget spécifié. Merci de contacter l'administrateur.",
    3 => "L'édition et la génération en direct pour les graphes multiples n'est pas disponible.",
    4 => "Vous n'avez pas le droit d'éditer ou de générer ce widget.",
    5 => "Vous devez vous connecter au moins une fois à l'atelier Infographie."
);

foreach ($this->error_type as $key => $value) {
    if(array_key_exists($value, $array_error)){
        $msg_error_html .= $array_error[(int)$value]."<br/>";
    }
}
?>
<!DOCTYPE html>
<html prefix="og: http://ogp.me/ns#" xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr-fr" lang="fr-fr" dir="ltr">
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <link href="<?= NGEURL_ROOT ?>components/com_nge/assets/css/all.css" rel="stylesheet" type="all" />
        <link href="<?= NGEURL_ROOT ?>components/com_nge/assets/css/screen.css" rel="stylesheet" type="screen" />
        <link href="<?= NGEURL_MEDIA ?>icomoon/icomoon-nge.css" rel="stylesheet"/>
        <link href="<?= NGEURL_ROOT ?>media/jui/css/bootstrap.min.css" rel="stylesheet"/>
        <style>
            div.ngePreviewWarning{
                border-left:4px solid #CD4E4B;
                padding: 5px 6px 4px 10px;
                font-size: 12px;
                background: rgba(205,78,75,0.08);
                margin-bottom: 5px;
            }

            div.ngePreviewWarning .close, div.ngePreviewInformation .close {
                position: relative;
                top: -2px;
                line-height: 18px;
                float: right;
                font-size: 20px;
                font-weight: bold;
                line-height: 18px;
                color: #000;
                text-shadow: 0 1px 0 #ffffff;
                opacity: 0.3;
                filter: alpha(opacity=20);
                cursor:pointer;
                border:transparent;
                background-color:#fff;
            }

            div.ngePreviewInformation{
                border-left:4px solid #4F73DB;
                padding-left:15px;
            }
            div.ngePreviewInformation h4    {
                color:#4F73DB;
            }
        </style>
    </head>
    <body>
        <div class="ngePreviewWarning">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <h4><span class="icomoon icomoon-warning"></span>&nbsp;Attention</h4>
            <?= $msg_error_html; ?>
        </div>
    </body>
</html>