<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * Small fast inline config screens
 * Used from frontend
 * To best response performance : 
 * Scripts are loaded once first in the permanent modal inlinconfig div : layout=scripts
 * Then each config content is loaded on demand and injected in the main div : #ngeinlinecontent
 * 
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
jimport('joomla.utilities.utility');

/**
 * View to edit
 */
class NgeViewInlineconfig extends JViewLegacy
{
	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
	    switch ($this->getLayout()){
		case 'scripts' : //displays the initial js and css libraries. Called once
		    parent::display($tpl);
		    break;
		case 'form' : //displays the form only without scripts
		    $this->loadForm();
		    break;
		default : //displays a config form (from each part directory) with the scripts, only for manual calling and debugging
		    include('components/com_nge/views/inlineconfig/tmpl/scripts.php');
		    $this->loadForm();
	    }	
	}	

	private function loadForm(){
	    //Incoming params
	    		
		$jinput = JFactory::getApplication()->input;
		$type = 		$jinput->get('type', 'part','string'); //Modifying existant part <ith the part id

		$app = JFactory::getApplication();
		
		if($app->isAdmin()) {
			$lang = JFactory::getLanguage();
			$lang->load('com_nge',JPATH_SITE);
		}

		switch ($type) {
		    case 'element' : //Element is a type of inline input field : text, image, glyph, editor...
				//Or anything, that can be used for more than one part.
			
			    $element = 		$jinput->get('element', '','string');
			    $id =			$jinput->get('id', '','int'); //Id of the element
			    $form = 		$jinput->get('form', '','string'); //File name for config form
			    
			    $element = str_replace('.', '/', $element);
			    $form = str_replace('.', '/', $form);
			    			    
			    $filename = NGEPATH_HELPERS . '/forms/elements/' . $element . '/' . $form.'.php';
			    if(file_exists($filename)) 
				include JPath::check($filename);
			break;
		    case 'pattern' : 
			    require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php'; 
			    require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php'; 

			    $patternName = $jinput->get('pattern_name', '', 'string');
			    $patternType = $jinput->get('pattern_type', '', 'string');
			    $value = $jinput->get('value', '', 'int');
			    $patternId = $jinput->get('pattern_id', '', 'string');
			    
			    if ($patternId != ''){
				//Loading pattern data and filling form
				$pattern = NgePatternDriver::load($patternId);
				$patternName = $pattern->name;
				$patternType = $pattern->type;
				//Loading pattern data and filling form
				//Main data : params of the part 
				if ($pattern->content != '')
				    $this->contentObject = json_decode($pattern->content, true); //Notice Json decoded as array
				else {//Loading default content in partlibrary for the pattern				
				    $defaultPatternContent = NGEDATA::loadResult('SELECT content FROM #__nge_parts_library WHERE part = ' . NGEDATA::quote($patternName));
				    if ($defaultPatternContent != null)
					$this->contentObject = json_decode($defaultPatternContent, true); //Notice Json decoded as array
				    else
					$this->contentObject = array();    
				}
				
				//Internal params of the pattern, can be access rights
				$this->paramsObject = json_decode($pattern->params, true); //Notice Json decoded as array
				$this->settingsObject = json_decode($pattern->settings, true); //Notice Json decoded as array
				//To correct bug in <2.1.0
				//When patterns where, updated type and name were stored empty
				$this->settingsObject['id'] = $pattern->id;
				$this->settingsObject['title'] = $pattern->title;
				$this->settingsObject['description'] = $pattern->description;
				$this->settingsObject['name'] = $pattern->name;
				$this->settingsObject['type'] = $pattern->type;
				$this->mode = 'edit';
				$this->key = $patternId;
			    }
			    else {
				//Loading default content in partlibrary for the pattern
				$defaultPatternContent = NGEDATA::loadResult('SELECT content FROM #__nge_parts_library WHERE part = ' . NGEDATA::quote($patternName));
				if ($defaultPatternContent != null)
				    $this->contentObject = json_decode($defaultPatternContent, true); //Notice Json decoded as array
				else
				    $this->contentObject = array();
				$this->paramsObject = array();
				$this->settingsObject = array();
				$this->settingsObject['type'] = $patternType;
				$this->settingsObject['name'] = $patternName;
				$this->mode = 'create';
				$this->key = $patternName;
			    }

			    $lang = JFactory::getLanguage();
			    $lang->load('com_nge_pack', JPATH_SITE);

			    if ($patternType == 'part')
				$namepath = explode('.', $patternName);
			    else
				$namepath = explode('.', $patternType . '.' . $patternName); //For subpatterns path includes patternType
			    
			    $this->directories = '';
			    $name = "";
			    for ($i = 0; $i < count($namepath)-1; $i++)
				$this->directories .= $namepath[$i] . '/';
			    $this->directories .= $namepath[$i];
			    
			    if ($patternType == 'part'){
				if (file_exists(NGEPATH_PARTS . '/' . $this->directories . '/pattern_options.php'))
				    $this->optionsFilename = NGEPATH_PARTS . '/' . $this->directories . '/pattern_options.php';
				else
				    $this->optionsFilename = NGEPATH_PARTS . '/' . $this->directories . '/config_options.php';
				if (file_exists(NGEPATH_PARTS . '/' . $this->directories . '/pattern_content.php'))
				    $this->contentFilename = NGEPATH_PARTS . '/' . $this->directories . '/pattern_content.php';
				else
				    $this->contentFilename = NGEPATH_PARTS . '/' . $this->directories . '/config_content.php';
			    }
			    else{
				$this->optionsFilename = NGEPATH_HELPERS . '/forms/patterns/' . $this->directories . '.php';
				$this->contentFilename = "";
			    }

			    $this->setLayout('pattern');
			    parent::display('pattern');

			break;

		case 'nge.item' : //Item is a identified existing tag in the page wich can have inline config; It is saved in the nge_items table
		    
			    $itemid =	 $jinput->getRaw('itemid'); //Unique id, can be the selector or string (body)
			    $itemselector =	 $jinput->getRaw('itemselector'); //Selector
			    $itemtype =	 $jinput->get('itemtype'); //Type of item
			    $itemtitle =	 $jinput->get('itemtitle'); 
			    $form = $jinput->get('form', '','string'); //File name for config form
			    
			    require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php';
			    require_once NGEPATH_HELPERS . '/data/nge/itemdriver.php';

			    $paramsObject = array();
			    $paramsObject['id'] = $itemid;
			    $paramsObject['selector'] = $itemselector;
			    $paramsObject['item'] = $itemtype;
			    $paramsObject['title'] = $itemtitle;

			    if ($itemid != ''){
				//Loading pattern data and filling form
				
				$item = NgeItemDriver::load($itemid);
				//Loading item data and filling form
				//Main data : params of the part 
				if ($item != null){
				    $paramsObject = json_decode($item->params, true); //Notice Json decoded as array

				    if (isset($item->id))		    $paramsObject['id'] = $item->id;
				    if (isset($item->item))	    $paramsObject['item'] = $item->item;
				    if (isset($item->selector))	    $paramsObject['selector'] = $item->selector;
				    if (isset($item->title))	    $paramsObject['title'] = $item->title;
				}
			    }
			    			    
			    $lang = JFactory::getLanguage();
			    $lang->load('com_nge_pack', JPATH_SITE);
			    
			    require_once NGEPATH_HELPERS . '/ngeconfighelper.php'; //Used in each config file to load the part form
			    //Part name contains directory + name
			    $itemname = preg_replace('/[^A-Z0-9_\.-]/i', '', $itemtype);
			    $itempath = explode('.', $itemname);
			    $directories = '';
			    $name = "";
			    for ($i = 0; $i < count($itempath); $i++)
				$directories .= $itempath[$i] . '/';
			    $path = NGEPATH_ITEMS . '/' . $directories;
			    //Setting default values of the form
			    NGEFields::setData($paramsObject);
			    if(file_exists($path . 'config.php')) 
				include JPath::check($path . 'config.php');
			    include JPATH_SITE . '/components/com_nge/views/inlineconfig/itemform.php';

			break;
		    case 'part.element' : 
			    require_once NGEPATH_HELPERS . '/forms/fields/ngefields.php';
			    require_once NGEPATH_HELPERS . '/ngeparthelper.php'; //Used in each config file to load the part form
			//Any form to be used for only one part. If not, use element instead
			    $id =		$jinput->get('id', '','int'); //Modifying existant part <ith the part id
			    $form =		$jinput->get('form', '','string'); //File name for config form
			    $element =	$jinput->get('element', '','string');
			    $multiselect = 	$jinput->get('multiselect', [],'array'); //File name for config form
			    $source =	$jinput->get('source');
			    $element = str_replace('.', '/', $element);

			    //Get Current config param info if pk exist else it's a new one
			    if(isset($id) && $id != ""){
				$part = NgePartsHelper::getPart('['.$id.']');

				//Load language file for this part
				NgePartHelper::loadPartConfigLanguage($id);

				//Loading data
				    $sourceArray = explode(':', $source);
				if (count($sourceArray) >1){
				    $field = $sourceArray[0];
				    $property = $sourceArray[1];
				}else{
					if($source === "content"){
					    $field = 'content';
					}else{
					    $field = 'params'; 
					}
				    $property = "";
				}
                                
				try{
				    $jsonArray = json_decode($part->$field, true);

				    if($property !== ""){ /*Widget with api*/
					//$content or params is an array of arrays.
					//searching the corresponding pointer (notice & reference)
					$propertyPointer = & $jsonArray;
					$keys = explode('.', $property);

					for ($i = 0; $i < count($keys); $i++) {
					    $propertyPointer = & $propertyPointer[$keys[$i]];
					}
					$formData = $propertyPointer;
				    }else{ /*Widget without api*/
					$formData = $jsonArray;
				    }
                                    
				    //Load data for field in the form: Used in modal live editing to get form for specific element (cell, row, point, serie...)
				    NGEFields::setData($formData);
				} catch(Exception $e){
				    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_LOADING_PART_CONTENT');
				}						

				//Data used in element forms, in tags used to load subforms in ajax
				$data = array();
				$data["mode"] = 'edit';
				$data["key"] = $id;				
				
				//Rendering inline config file
				$partname = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
				//Part name contains directory + name
				$partpath = explode('.', $partname);
				$directories = '';
				$name = "";
				for ($i = 0; $i < count($partpath); $i++)
				    $directories .= $partpath[$i] . '/';
				$form = str_replace('.', '/', $form);				
				//$path = JPATH_SITE . '/components/com_nge/parts/wizards/' . $directories;
				//$path = JPATH_SITE . '/components/com_nge/parts/' . $directories . 'wizards/';
								
				//If form exists in part directory, use it in priority.
				//If not, in common elements dir				
				$fileName = NGEPATH_PARTS . '/' . $directories . 'forms/' . $element . '/' . $form.'.php';
				if(file_exists($fileName)){
				    include JPath::check($fileName);
				}else {								    
				    $fileName = NGEPATH_HELPERS . '/forms/elements/' . $element . '/' . $form.'.php';
				    if(file_exists($fileName))
					include JPath::check($fileName);
				}
				//Including token field and common saving scripts
				include JPATH_SITE . '/components/com_nge/views/inlineconfig/partelementform.php';
				
			    }		
			break;
		    case 'joomla.position' : 
			//Any form to be used for only one part. If not, use element instead
			    $params = array();
			    $params['pk'] =	 $jinput->getInt('pk'); //Modifying existant part <ith the part id
			    $form =	 $jinput->get('form');
			    
			    if ($form != '') {
				$filename = NGEPATH_HELPERS . '/forms/joomla/position/' . $form . '.php';
				if(file_exists($filename)){
				    include JPath::check($filename);
				}
			    }
			break;
			
		    default : //part
			//Any form to be used for only one part. If not, use element instead
			    $params = array();
			    $params['pk'] =	 $jinput->getInt('pk'); //Modifying existant part <ith the part id
			    $params['form'] =	 $jinput->get('form');
			    $params['options'] = array();
			    
			    $this->pk = $params['pk'];// Modification mode : part id
			    
			    //$form = $jinput->get('form', '','string'); //File name for config form
			    // Get config screen
			    require_once NGEPATH_HELPERS . '/ngeparthelper.php'; //Used in each config file to load the part form
			    require_once NGEPATH_HELPERS . '/ngeconfighelper.php'; //Used in each config file to load the part form

			    //Get Current config param info if pk exist else it's a new one
			    if($params['pk'] != ""){
				//$part = NgePartsHelper::getPart('['.$id.']');
				//Load language file for this part
				NgePartHelper::loadPartConfigLanguage($params['pk']);
				
				$configForm = NgeConfigHelper::getForm($params);
				echo $configForm->formcontent;
				//Including token field and common saving scripts
				include JPATH_SITE . '/components/com_nge/views/inlineconfig/partform.php';
			    }		
			break;
		}
	}
}