<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
?>
<div id="field_articles_list">
    <div id="nge-manager-articles-toolbar">
	<div id="ngebtn-articles-refresh" class="managerbtn" type="button"><i class="icomoon icomoon-loop2" title="<?php echo JText::_('COM_NGE_REFRESH'); ?>"></i></div>
	<input type="text" class="search nge-manager-search" placeholder="<?php echo JText::_('COM_NGE_SEARCH'); ?>" autofocus>
    </div>
    <div class="row-fluid" style="background-color:#f7f7f7">
	<div class="span3" style="text-align:right;min-height: 100vh;background-color:#fff;padding-right:20px;border-right: 1px solid #ddd;box-shadow: 0 7px 14px 0 rgba(0,0,0,.3);">
	    <h3 style="color:#aaa;"><?php echo NGE::translate('COM_NGE_FIELD_ARTICLE_LEGEND_TITLE'); ?></h3><?php echo NGE::translate('COM_NGE_FIELD_ARTICLE_LEGEND'); ?><br/><br/><br/><br/><i><a href="<?php echo NGEURL_ROOT; ?>administrator/index.php?option=com_content" target="blank"><?php echo NGE::translate('COM_NGE_FIELD_ARTICLE_LEGEND_LINK'); ?></a></i></div>
	<div class="span9 manager_body" style="width:72%">
	    <table id="ngeListArticle" cellspacing="0" width="100%">
		<thead>
		    <tr>
			<th class="sort" data-sort="title"><?php echo JText::_('COM_NGE_TITLE'); ?></th>
			<th class="sort" data-sort="category"><?php echo JText::_('COM_NGE_CATEGORY'); ?></th>
			<th class="sort" data-sort="author"><?php echo JText::_('COM_NGE_AUTHOR'); ?></th>
			<th class="sort" data-sort="created"><?php echo JText::_('COM_NGE_DATE'); ?></th>
			<th class="sort" data-sort="hits"><?php echo JText::_('COM_NGE_HITS'); ?></th>
			<th class="sort" data-sort="id"><?php echo JText::_('COM_NGE_ID'); ?></th>
		    </tr>
		</thead>
		<tbody class="list">
		    <tr><td class="title"></td><td class="category"></td><td class="author"></td><td class="article"></td><td class="hits"></td><td class="id"></td></tr>
		</tbody></table>  
	    <ul class="paginationArticlesBottom"></ul>
	</div>
    </div>
</div>    
    <style>
	#ngeListArticle  {
	    overflow-y: scroll;
	}
	#ngeListArticle thead th, #ngeListArticle tbody td {
	    padding: 5px;
	}

	#ngeListArticle{
	    margin-top:10px;
	}

	#ngeListArticle{
	    width:100%;
	    color:#999;
	}

	#ngeListArticle th {
	    color: #999;
	    text-align:left;
	}
	#ngeListArticle tbody tr {
	    cursor:pointer;
	    background-color: white;
	    border-bottom:1px solid #eee;
	    transition: color 500ms linear, background-color 500ms linear;
	}
	#ngeListArticle tbody tr:hover {
	    color:#fff;
	    background-color: #4EA5E2;
	}	
	
	#ngeListArticle td.title {
	    color:#555;
	    transition: color 500ms linear;
	}
	#ngeListArticle tbody tr:hover td.title {
	    color:#fff;
	}
	
	#nge-manager-articles-toolbar{
	    background-color: #84C0EA;
	    text-align:right;
	    padding-right:10px;
	}
	.managerbtn{
	    color:#fff;
	    display:inline;
	    padding: 10px 12px;
	    text-align: center;
	    vertical-align: middle;
	}
	.managerbtn:not(.disabled){
	    cursor: pointer;
	}
	.managerbtn.disabled{
	    color:#aaa;
	}
	.managerbtn:not(.disabled):hover{
	    background-color:#4EA5E2;
	}
	input[type="text"].nge-manager-search{
	    margin:4px;
	}
	.paginationArticlesBottom{
	    float:right;
	}
	.paginationArticlesBottom li{
	    display: inline-block;
	    padding: 5px;
	    border: 1px solid #ddd;
	    min-width: 16px;
	    text-align: center;
	}

	.paginationArticlesBottom li:hover{ 
	    background-color:#ddd;    
	}


    </style>
    <script>

	var paginationArticlesBottomOptions = {
	    name: "paginationArticlesBottom",
	    paginationClass: "paginationArticlesBottom",
	    innerWindow: 3,
	    left: 2,
	    right: 4
	};
	var options = {
	    valueNames: ['title', 'category', 'author', 'created', 'hits', 'id'],
	    item: '<tr><td class="title"></td><td class="category"></td><td class="author"></td><td class="article"></td><td class="hits"></td><td class="id"></td></tr>',
	    page: 10,
	    plugins: [
		ListPagination(paginationArticlesBottomOptions)
	    ]
	};

	var values = <?php echo json_encode($this->data); ?>;

	var fieldArticlesList = new List('field_articles_list', options, values);

	jQuery("#ngeListArticle tbody").on("click", "tr", function () {
	    $fieldArticle.find(".ngefield-article-id")[0].value = jQuery(this).find('td:eq(5)').text();
	    $fieldArticle.find(".ngefield-article-name")[0].value = jQuery(this).find('td:eq(0)').text();
	    jQuery("#ngeArticleManager").modal("hide");
	    $fieldArticle.find(".ngefield-article-id").trigger("change");
	});

	jQuery("#ngebtn-articles-refresh").unbind('click').click(function (e) {
        var $articleContent = jQuery("#ngearticle-content");
       	var obj_data_internal = jQuery('.ngeinternalform');
        if(obj_data_internal) {
           	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
        	str_data_internal = str_data_internal.replace(/\"/g, "");
         }
        else
            str_data_internal='{}';
	    jQuery('.manager_body').html('<img style="margin:50px auto; display:block;" width="30" src="' + rootUrl + 'components/com_nge/assets/images/spinner.gif" />');
	    jQuery.ajax({
		url: baseUrl + "index.php?option=com_nge&view=field_ngearticle&layout=default&format=raw",
            type: 'POST',
            data : str_data_internal,
		success: function (result) {
		    try {
			jQuery("#ngearticle-content").html(result);
		    } catch (err) {
			console.error("Error : to load list of articles!<br>" + err.toString());
		    }
		},
		error: function (xhr) {
		    $articleContent.html(xhr.responseText);
		    console.error("Error : to load list of articles!");
		},
		complete: function () {
		},
	    });
	});

    </script>