<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	

jimport('joomla.html.sliders');
jimport('joomla.application.module.helper');

class NgeViewCpanel extends JViewLegacy
{
	protected $canDo;
	protected $app;
	protected $icons;
	protected $modules;
	
	function display( $tpl = null )
	{
	    $this->updateExtraQuery(); 
		$this->app		= JFactory::getApplication();
		$lang 			= JFactory::getLanguage();
		$bootstrapParams = $this->getBootstrapParams();
		$cpanelModel = JModelLegacy::getInstance( 'cpanel', 'NgeModel' );
 		$pluginsParams = $cpanelModel->getPluginsParams();

		// direct download link for nge editors PluginsController
		
		$download_links = array(
				'jce' => 'http://www.nextgeneditor.com/download/jceaddon_nge',
				'jckeditor' => 'http://www.nextgeneditor.com/download/jckplugin_nge',
				'arkeditor' => 'http://www.nextgeneditor.com/download/arkplugin_nge'
		);
		$this->download_links = $download_links;

        // get installed plugin list
        $plg_model = JModelList::getInstance("Plugins","NgeModel");
        $plugins_list = $plg_model->getItems();
        if ( !count($plugins_list) )
            $plugins_list=Array();
            
        $this->plugins_list = $plugins_list;
        // version of core plugin for component version
        $this->core_version = 0;
        foreach($plugins_list as $plugin) {
            if($plugin->type=='core')
                $this->core_version = $plugin->version;
        }
        
        $this->bootstrapParams = $bootstrapParams;
        $this->pluginsParams = $pluginsParams;
		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar()
	{
		$bar 	= JToolBar::getInstance('toolbar');

		JToolBarHelper::title( JText::_( 'COM_NGE_MANAGER_NGE' ), 'cpanel.png' );

        JToolbarHelper::preferences('com_nge');

        JHtmlSidebar::addEntry(JText::_( 'JEP_PLUGINS_PANEL' ), 'index.php?option=com_nge&view=cpanel',true);
        JHtmlSidebar::addEntry(JText::_( 'JEP_MANAGE_PLUGINS' ), 'index.php?option=com_nge&view=plugins',false);
       // JHtmlSidebar::addEntry(JText::_( 'JEP_INSTALL_PLUGIN' ), 'index.php?option=com_nge&view=install',false);


		$this->sidebar = JHtmlSidebar::render();
	}//end function
	
	protected function getBootstrapParams(){
		$componentParams = JComponentHelper::getParams('com_nge');

		$result = array();
		
		$result['bootstrap_version'] = new stdClass();
		$result['bootstrap_js'] = new stdClass();
		$result['bootstrap_css'] = new stdClass();
		
		$result['bootstrap_version']->name = JText::_( 'COM_NGE_B_C_VERSION' );
		$result['bootstrap_js']->name = JText::_( 'COM_NGE_B_C_JS' );
		$result['bootstrap_css']->name = JText::_( 'COM_NGE_B_C_CSS' );
		
		$result['bootstrap_version']->value = $componentParams->get("bootstrap_version", 2);

		switch ($componentParams->get("bootstrap_js_source")) {
			case "joomla":
				$result['bootstrap_js']->value = JText::_( 'COM_NGE_B_C_S_JOOMLA' );
				break;
			case "bootstrap":
				$result['bootstrap_js']->value = JText::_( 'COM_NGE_B_C_S_OFFICIAL' );
				break;
			default:
				$result['bootstrap_js']->value = JText::_( 'COM_NGE_B_C_S_CURRENT' );
				break;				
		}
		
		switch ($componentParams->get("bootstrap_css_source")) {
			case "joomla":
				$result['bootstrap_css']->value = JText::_( 'COM_NGE_B_C_S_JOOMLA' );
				break;
			case "bootstrap":
				$result['bootstrap_css']->value = JText::_( 'COM_NGE_B_C_S_OFFICIAL' );
				break;
			case "theme":
				$result['bootstrap_css']->value = JText::_( 'COM_NGE_B_C_S_THEME').' : <strong>'.$componentParams->get("bootstrap_theme")."</strong>";
				break;
			case "url":
				$result['bootstrap_css']->value = JText::_( 'COM_NGE_B_C_S_THEME_URL').' : '.$componentParams->get("bootstrap_url");
				break;
			default:
				$result['bootstrap_css']->value = JText::_( 'COM_NGE_B_C_S_CURRENT' );
				break;		
		}
        		
        if($componentParams->get("bootstrap_js_source")!='template' || $componentParams->get("bootstrap_css_source")!='template') {
            
            $result['bootstrap_loading'] = new stdClass();
    		$result['bootstrap_loading']->name = JText::_( 'COM_NGE_B_C_LOADING' );
		    switch ($componentParams->get("bootstrap_loading")) {
    			case "after_template":
    				$result['bootstrap_loading']->value = JText::_( 'COM_NGE_B_C_L_AFTER' );
    				break;
    			default:
    				$result['bootstrap_loading']->value = JText::_( 'COM_NGE_B_C_L_BEFORE' );
    				break;			
    		}
        }
		
		return $result;
	}
    
    /**
     * NgeViewCpanel::updateExtraQuery()
     * update table update_sites with the subscription_id in extra_query
     * 
     * @return void
     */
    protected function updateExtraQuery() {
        
        $componentParams = JComponentHelper::getParams('com_nge');
        
        $subscriptionId = $componentParams->get('subscription_id','');
        
   	    $extra_query = '';
    	if($subscriptionId != '') 
    		$extra_query = 'subscription_id='.$subscriptionId;
    		
    	// update table
    	$sql = sprintf('UPDATE #__update_sites SET extra_query="%s" 
    				WHERE update_site_id=(SELECT update_site_id FROM #__update_sites_extensions sie 
    										LEFT JOIN #__extensions ext ON sie.extension_id=ext.extension_id 
    										WHERE ext.element="pkg_nge")', $extra_query);
        $db	= JFactory::getDBO();
		$db->setQuery( $sql) ;
		$db->execute();
    }
}