<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * Warning : can be used both from Frontend or Backend.
 * All the files from libraygalleryview are copied once in the /components/com_nge/views directory 
 * and once in the /administrator/components/com_nge/views directory
 * Due to internal login limitations :
 * When Front editing : the current user is logged only front
 * When Back editing : the current user is logged only back
 * So the view is duplicated, but then calls common front helpers and font parts
 
 * 
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
jimport('joomla.utilities.utility');

/**
 * View to edit
 */
class NgeViewConfig extends JViewLegacy
{
	protected $state;
	protected $item;
	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
	    	    
	    //First ACL check (others cheks following)
	    $jinput = JFactory::getApplication()->input;
	    $this->pk =	    $jinput->getInt('pk'); 
	    $this->user =	    JFactory::getUser();		
	    if ($this->pk){
		if (!$this->user->authorise('core.edit','com_nge')){
		    echo NGE::translate('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED');
		    exit();
		}
	    }
	    else {
		if (!$this->user->authorise('core.create','com_nge')){
		    echo NGE::translate('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED');
		    exit();
		}
	    }
	    
	    switch ($this->getLayout()){
		case 'scripts' : //displays the initial js and css libraries. Called once
			$params = JComponentHelper::getParams('com_nge');
			$this->editParams = new stdClass();
			$this->editParams->showPreview = $params->get('show-preview',1);
			$this->editParams->demoMode = false;
			
			/* Loading language preview (for timeout message) */
			$lang = JFactory::getLanguage();
			$lang->load('com_nge_preview', JPATH_SITE);
			$lang->load('com_nge_pack', JPATH_SITE);
			
			parent::display($tpl);
			break;
		case 'form' : //displays only the form html. To be called inside the initial (scripts form)
		case 'subform' : //displays only the form html. To be called inside the initial (scripts form)
		
			$jinput = JFactory::getApplication()->input;
			$this->caller = 		$jinput->get('caller'); //Type of screen caller : for example tinymce for calling for tinymce screen
			$this->mode = 		$jinput->get('mode'); //Mode of the calling form : create (new part), edit (existing part), duplicate(part)		
			$this->plname = 		$jinput->get('plname'); //Creating new part with the library id
			$this->medium = 		$jinput->get('medium'); //Destination of the new part : article, page, report, publication...
			$this->mediumId =		$jinput->getInt('medium_id');
			$storeSource =		$jinput->get('storedsource'); //If defined, part params will be loaded from history table, for recovery

			//$params = JComponentHelper::getParams('com_nge');

			$this->editParams = new stdClass();
			if (NGE::features('nge.premium')){
			    if ($this->pk){ //Existing part
				    //User can edit parts?
				    $canEditPart = $this->user->authorise('core.edit','com_nge.part.'.$this->pk);
				    //User can edit its own parts ?
				    if (!$canEditPart){
					if ($this->user->authorise('core.edit.own', 'com_nge.part.' . $this->pk)){
					    // Existing record already has an owner, get it
					    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
					    $part = NgeNgePartDriver::load($this->pk);
					    if (empty($part)) 
						$canEditPart = false;
					    // Grant if current user is owner of the record
					    $canEditPart = $this->user->id == $part->created_by;
					}
				    }
				    if (!$canEditPart){
					echo JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $this->pk);
					exit();
				    }

				    $this->editParams->editContent = $this->user->authorise('core.edit.content','com_nge.part.'.$this->pk);
				    $this->editParams->editOptions = $this->user->authorise('core.edit.options','com_nge.part.'.$this->pk);
				    $this->editParams->editDisplay = $this->user->authorise('core.edit.display','com_nge.part.'.$this->pk);
				    $this->editParams->editAccess = NGE::features('parts.access') && $this->user->authorise('core.edit.access','com_nge.part.'.$this->pk);				
			    }else { //New part
				if (!$this->user->authorise('core.create','com_nge.part')) {
				    $this->editParams->editContent = 0;
				    $this->editParams->editOptions = 0;
				    $this->editParams->editDisplay = 0;
				    $this->editParams->editAccess = 0;
				}else {			
				    $this->editParams->editContent = 1; //If we can create new part, Content is enabled
				    $this->editParams->editOptions = $this->user->authorise('core.edit.options','com_nge.part');
				    $this->editParams->editDisplay = $this->user->authorise('core.edit.display','com_nge.part');
				    $this->editParams->editAccess = NGE::features('parts.access') && $this->user->authorise('core.edit.access','com_nge.part');
				}
			    }
			}
			else {
			    if ($this->pk){ //Existing part
				$canEditPart = $this->user->authorise('core.edit','com_nge');
				$this->editParams->editContent = $canEditPart;
				$this->editParams->editOptions = $canEditPart;
				$this->editParams->editDisplay = $canEditPart;
				$this->editParams->editAccess = 0;
			    }else { //New part
				$canCreatePart = $this->user->authorise('core.create','com_nge');
				$this->editParams->editContent = $canCreatePart;
				$this->editParams->editOptions = $canCreatePart;
				$this->editParams->editDisplay = $canCreatePart;
				$this->editParams->editAccess = 0;
			    }
			}	    

			// Get config screen
			require_once NGEPATH_HELPERS . '/ngepartshelper.php'; //Used in each config file to load the part form
			require_once NGEPATH_HELPERS . '/ngeparthelper.php'; //Used in each config file to load the part form
			require_once NGEPATH_HELPERS . '/ngecontenthelper.php'; //Used in each config file to load the part form		
			require_once NGEPATH_HELPERS . '/ngeconfighelper.php'; //Used in each config file to load the part form		

			//Get Current config param info if pk exist else it's a new one
			if($this->pk){
				if ($storeSource == 'history'){
				    require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php';
				    $this->part = NgePartsHistoryHelper::getPart('['.$this->pk.']');
				}
				else{
				    require_once NGEPATH_HELPERS . '/ngepartshelper.php';
				    $this->part = NgePartsHelper::getPart('['.$this->pk.']');
				}

				//Loading history list for recovery capabilities
				if (NGE::features('nge.pro')) {
				    require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php'; 
				    $this->partHistory = NgePartsHistoryHelper::getHistory($this->pk);
				}
			}else{
			    if ($this->plname != ''){
				$partLibrary = NgePartsHelper::getLibraryGallery($this->plname);
				$this->part = new stdClass();
				$this->part->name = $this->plname;
				$this->part->title_library = $partLibrary->title;
				$this->part->version = $partLibrary->version;
				$this->partHistory = array(); 
			    }
			}

			//Load language file for this part
			if ($this->plname != '')
				NgePartsHelper::loadPackConfigLanguage($this->plname);
			else
				NgePartHelper::loadPartConfigLanguage($this->pk);

			 // position if set in $_REQUEST when dropping a part in a module
			$this->position = $jinput->get('end_position','');
			$this->m_before_id = $jinput->get('m_before_id',0);
			parent::display($tpl);
			break;
		default : //displays a config form (from each part directory) Used in administration

			$jinput = JFactory::getApplication()->input;
			$this->caller = 		$jinput->get('caller', '','string'); //Type of screen caller : for example tinymce for calling for tinymce screen
			$this->mode = 		$jinput->get('mode', '','string'); //Mode of the calling form : create (new part), edit (existing part), duplicate(part)
			$this->selection = 		$jinput->getRaw('selection'); //If selected, text in the calling editor
			$this->plname = 		$jinput->get('plname', '','string'); //Creating new part with the library id
			$this->medium = 		$jinput->get('medium', '','string'); //Destination of the new part : article, page, report, publication...
			$this->mediumId = 		$jinput->get('medium_id', '','int');


			// if in admin, load front component lang file
			$app = JFactory::getApplication();

			//$params = JComponentHelper::getParams('com_nge');
			$this->editParams = new stdClass();
			//$params = JComponentHelper::getParams('com_nge');

			//$this->editParams->showPreview = $params->get('show-preview',1);
			$this->editParams->showPreview = true;
			$this->editParams->demoMode = false;		
			if (NGE::features('nge.premium')){
			    if ($this->pk){ //Existing part
				    //User can edit parts?
				    $canEditPart = $this->user->authorise('core.edit','com_nge.part.'.$this->pk);
				    //User can edit its own parts ?
				    if (!$canEditPart){
					if ($this->user->authorise('core.edit.own', 'com_nge.part.' . $this->pk)){
					    // Existing record already has an owner, get it
					    require_once (NGEPATH_HELPERS . '/data/nge/partdriver.php');
					    $part = NgeNgePartDriver::load($this->pk);
					    if (empty($part)) 
						$canEditPart = false;
					    // Grant if current user is owner of the record
					    $canEditPart = $this->user->id == $part->created_by;
					}
				    }
				    if (!$canEditPart){
					echo JText::sprintf('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED', $this->pk);
					exit();
				    }

				    $this->editParams->editContent = $this->user->authorise('core.edit.content','com_nge.part.'.$this->pk);
				    $this->editParams->editOptions = $this->user->authorise('core.edit.options','com_nge.part.'.$this->pk);
				    $this->editParams->editDisplay = $this->user->authorise('core.edit.display','com_nge.part.'.$this->pk);
				    $this->editParams->editAccess = NGE::features('parts.access') && $this->user->authorise('core.edit.access','com_nge.part.'.$this->pk);				
			    }else { //New part
				if (!$this->user->authorise('core.create','com_nge.part')) {
				    $this->editParams->editContent = 0;
				    $this->editParams->editOptions = 0;
				    $this->editParams->editDisplay = 0;
				    $this->editParams->editAccess = 0;
				}else {			
				    $this->editParams->editContent = 1; //If we can create new part, Content is enabled
				    $this->editParams->editOptions = $this->user->authorise('core.edit.options','com_nge.part');
				    $this->editParams->editDisplay = $this->user->authorise('core.edit.display','com_nge.part');
				    $this->editParams->editAccess = NGE::features('parts.access') && $this->user->authorise('core.edit.access','com_nge.part');
				}
			    }
			}
			else {
			    if ($this->pk){ //Existing part
				$canEditPart = $this->user->authorise('core.edit','com_nge');
				$this->editParams->editContent = $canEditPart;
				$this->editParams->editOptions = $canEditPart;
				$this->editParams->editDisplay = $canEditPart;
				$this->editParams->editAccess = 0;
			    }else { //New part
				$canCreatePart = $this->user->authorise('core.create','com_nge');
				$this->editParams->editContent = $canCreatePart;
				$this->editParams->editOptions = $canCreatePart;
				$this->editParams->editDisplay = $canCreatePart;
				$this->editParams->editAccess = 0;
			    }
			}	    
			
			// Get config screen
			require_once NGEPATH_HELPERS . '/ngepartshelper.php'; //Used in each config file to load the part form
			require_once NGEPATH_HELPERS . '/ngeparthelper.php'; //Used in each config file to load the part form
			require_once NGEPATH_HELPERS . '/ngecontenthelper.php'; //Used in each config file to load the part form		
			require_once NGEPATH_HELPERS . '/ngeconfighelper.php'; //Used in each config file to load the part form		

			//Get Current config param info if pk exist else it's a new one
			if(isset($this->pk) && $this->pk != ""){
				$this->part = NgePartsHelper::getPart('['.$this->pk.']');
			}else{
				$partLibrary = NgePartsHelper::getLibraryGallery($this->plname);
				    $this->part = new stdClass();
				    $this->part->name = $this->plname;
				    $this->part->title_library = $partLibrary->title;
				    $this->part->version = $partLibrary->version;
			}

			//Load language file for this part
			if ($this->plname != '')
				NgePartsHelper::loadPackConfigLanguage($this->plname);
			else
				NgePartHelper::loadPartConfigLanguage($this->pk);


			 // position if set in $_REQUEST when dropping a part in a module
			$this->position = $jinput->get('end_position','');
			$this->m_before_id = $jinput->get('m_before_id',0);
			parent::display($tpl);
	    }
	}

	

}
