<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * Full form for editing part
 * Saving all properties as new ones (replace)
 */
// no direct access
defined('_JEXEC') or die;

//Used when called in administration
$pkUrl = '';
if (isset($this->mode))	$pkUrl .= '&mode=' . $this->mode;//Creation mode : nge_parts_library id
if (isset($this->plname))	$pkUrl .= '&plname=' . $this->plname;//Creation mode : nge_parts_library id
if (isset($this->pk))		$pkUrl .= '&pk=' . $this->pk;// Modification mode : nge_parts id    
if (isset($this->medium))	$pkUrl .= '&medium=' . $this->medium; // In creation mode, destination type for the part    
if (isset($this->mediumId))	$pkUrl .= '&medium_id=' . $this->mediumId;// In creation mode, destination id for the part
if (isset($this->caller))		$pkUrl .= '&caller=' . $this->caller;// In creation mode, destination type for the part
if (isset($this->viewmode))	$pkUrl .= '&viewmode=' . $this->viewmode;// Parts rendering view mode (default, thumbnails, wireframe...
if (isset($this->position))	$pkUrl .= '&position=' . $this->position;// In creation mode, destination type for the part
if (isset($this->m_before_id))	$pkUrl .= '&m_before_id=' . $this->m_before_id;// In creation mode, destination type for the part    
$pkUrl .= '&Itemid=155'; //todo, a  faire comme medium_id

if (!isset($this->caller))    $this->caller = '';
if (!isset($this->mode))    $this->mode = '';

?>
<script>
    var config_screen = "config";
    var preview_display = "desktop";
    var previewIsLoading = false; // Preview is being loaded in ajax, but has not responded yet
    var previewInitpageLoaded = false; // Initial preview page is loaded. This page is a full web site html page with all scripts and css styles
    var previewHasError = false;
    var timerPreviewPart; 
    var po_map = new Object();
    var pkUrl;
    var caller;
    var mode;

    //Used when called in administration
    var config_screen = "config";
    //Updating javascript variables to be used by the main initial scripts
    pkUrl = "<?php echo $pkUrl; ?>";
    caller = "<?php echo $this->caller; ?>";
    mode = "<?php echo $this->mode; ?>";

    function getPreviewWidth() {
        var preview_width = '100%';
        switch(preview_display) {
            case 'desktop':
                preview_width = '100%';
                /*preview_width = '1280px';*/
                break;
            case 'tablet-portrait':
                preview_width = '768px';
                break;
            case 'smartphone-landscape':
                preview_width = '568px';
                break;
             case 'smartphone-portrait':
                preview_width = '320px';
                break;
        }
        
        return preview_width;
    }
    
    function getPreviewHeight() {
        var preview_width = '100%';
        switch(preview_display) {
            case 'tablet-landscape' :
                preview_width = '768px';
                break;
            case 'tablet-portrait':
                preview_width = '1024px';
                break;
            case 'smartphone-landscape':
                preview_width = '320px';
                break;
             case 'smartphone-portrait':
                preview_width = '568px';
                break;
        }
        
        return preview_width;
    }

    function changeDisplay(element, display) {
        preview_display = display;
        jQuery('#dropdown_display_label').html(jQuery(element).find("tr").children('td:first').html());
        previewPart();
    }

    function showMessage(titleStr, messageStr) {
	bootbox.dialog({
	    message: messageStr,
	    title: titleStr,
	    buttons: {
		success: {
		    label: "Close",
		    className: "btn-cancel",
		    callback: function () {

		    }
		}
	    }
	});
    }

    jQuery(document).on( "ngeConfigChange", function() {
	if (jQuery("#previewswitch").prop("checked")){
	    /*clearTimeout(timerPreviewPart);
	    timerPreviewPart = setTimeout(previewPart, 300);*/	    
	    previewPart();
	}
    });
    
    
/*
 * animation : show fade effect O/N
 * @returns {undefined}
 */
    function previewPart(animation){
        <?php
        /* param option : ShowPreview*/
        if ($this->editParams->showPreview) :
        ?>						
	if (!previewIsLoading) { //an ajax loading is already in course	    
	    partPreviewOnLoad();
	    jQuery("#help_container").hide();
	    jQuery("#history_container").hide();
	    jQuery("#preview_container").show();
	    /*Get all form data*/
	    //Warning, must specify forms id. selector('form') can take unwanted popup inline forms
	    //All forms to be included in preview or saving must have one of these classes 
	    var $frm = jQuery('form.ngecontentform, form.ngeoptionsform, form.ngedisplayform, form.ngeinternalform');
	    var dataAjax = JSON.stringify($frm.serialize());
	    dataAjax = dataAjax.replace(/\"/g, "");
	    
	    if (!previewInitpageLoaded) { /* No initial preview page already loaded. This page is a full html with all current styles */
		jQuery("#preview_spinner").show();
		jQuery("#preview_container").css('visibility', 'hidden');
		if(jQuery("#iframepreview")[0] === undefined){ /*The first time and iframe not created*/
		    jQuery.ajax({
			url: "<?php echo NGEURL_BASE; ?>index.php?option=com_nge&view=part"+pkUrl + "&layout=preview&nge=0",
			data: dataAjax,
			type: 'POST',
			success: function (result) {
				var newIframe = document.createElement('iframe');
				newIframe.width = '100%';
				newIframe.src = 'about:blank'; 
				newIframe.id = 'iframepreview';
				newIframe.frameBorder ="0";
				jQuery("#preview_container").html("");
				document.getElementById('preview_container').appendChild(newIframe);
				newIframe.contentWindow.document.open();
				newIframe.contentWindow.document.write(result);
				newIframe.contentWindow.document.close();
				jQuery("#preview_spinner").fadeOut( "fast", function() {
				    jQuery("#preview_container").css("visibility", "visible");
				});
				previewInitpageLoaded = true;
			}
		    });
		}
	    }else{ /*Iframe already created*/
		var previewIframe = document.getElementById("iframepreview");
		if (previewIframe !== null){
		    previewIframe.contentWindow.loadPartHtml(pkUrl, dataAjax, animation);
		}
	    }
	}
        <?php endif; ?>
    };

/*
 * Call preview for a stored version of the part
 * animation : show fade effect O/N
 * @returns {undefined}
 */
    function previewHistory(hk, modified){
        <?php
        /* param option : ShowPreview*/
        if ($this->editParams->showPreview) :
        ?>
	if (!previewIsLoading) { //an ajax loading is already in course
	    partPreviewOnLoad();
	    jQuery("#help_container").hide();
	    jQuery("#preview_container").show();
            document.getElementById("iframepreview").contentWindow.loadPartHistoryHtml(hk, modified, 'fade');
	}
        <?php endif; ?>
    };

    function partPreviewOnLoad() {
	previewIsLoading = true;
	/* Start timer. If more than 30 seconds : displays error */
	//timerPreviewPart = setTimeout(partPreviewOnTimeout, 30000);
    }
    function partPreviewOnLoaded() {
	clearTimeout(timerPreviewPart);
	previewIsLoading = false;
	previewHasError = false;
    }
    function partPreviewOnTimeout() {
	previewIsLoading = false;
	previewHasError = true;
	var errorMessage = '<div class="ngePreviewWarning">';
	errorMessage += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
	errorMessage += '<h4><span class="icomoon icomoon-warning"></span>&nbsp;<?php echo addslashes(NGE::translate('COM_NGE_WARNING')); ?></h4>';
	errorMessage += '<?php echo addslashes(NGE::translate('COM_NGE_WARNING_PREVIEW_TIMEOUT')); ?></div>';
	jQuery("#preview_container").html(errorMessage);
	jQuery("#preview_spinner").fadeOut( "fast", function() {
	    jQuery("#preview_container").css("visibility", "visible");
	});
    }
	    
    function helpPart() {
	if (!previewIsLoading) {
	    partPreviewOnLoad();
	    jQuery("#preview_container").hide();
	    jQuery("#history_container").hide();
	    jQuery("#help_container").show();
	    
	    jQuery("#help_container").html('<div style="text-align:center;margin-top:50px;"><img src="<?php echo JUri::root() ?>components/com_nge/assets/images/spinner.gif" /></div>');

	    //var frm = jQuery(document.configform);
	    var frm = jQuery('form'); //All forms
	    var data = JSON.stringify(frm.serialize());
	    data = data.replace(/\"/g, "");
	    data += '&<?php echo NGE::token(); ?>=1';

	    jQuery("#help_container").css('visibility', 'hidden');
	    jQuery.ajax({
		url: "<?php echo juri::root() ?>index.php?option=com_nge&task=part.help"+pkUrl,
			data: data,
			type: 'POST',
			success: function (result) {
			    jQuery("#help_container").html(result).stop().css('visibility', 'visible');
			},
			complete: function (result, statut) {
			    partPreviewOnLoaded();
			}
	    });
	}
    }
    
    function resetPart() {
    if (caller == 'layout')
	window.parent.document.removeTemporaryThumb();
    }

    function savePart() {
	///If demo Mode : alert and no save
	<?php //if ($this->editParams->demoMode) : ?>
		<?php if (NGE::features('nge.demo')) : ?>		
	alert("<?php echo NGE::translate('COM_NGE_DEMO_MODE_MESSAGE') ?>");

	<?php else : ?>

	//Updating tinymce editor instances
	try {
	    if (!(typeof tinymce === "undefined") && !(tinymce == null)) {
		for (var i = 0; i < tinymce.editors.length; i++) {
		    tinymce.editors[i].save();
		}
	    }
	}
	catch (e) {
	    console.error('error while saving tinyMCE editor : ' + e.message)
	}

	// update ckeditor instances
	try {
	    if (typeof CKEDITOR !== 'undefined') {
		CKEDITOR = window.CKEDITOR;
		for (var id in CKEDITOR.instances) {
		    CKEDITOR.instances[id].updateElement();
		}
	    }
	}
	catch (e) {
	    console.error('error while saving CkEditor editor : ' + e.message)
	}

	// separate content and params
	//Content will be saved in the content field, and params in the params field         
	//var obj_data_content = jQuery('#contentform');
	var obj_data_content = jQuery('.ngecontentform');
	var obj_data_params = jQuery('.ngeoptionsform');
	var obj_data_display = jQuery('.ngedisplayform');
	var obj_data_access = jQuery('#accessform');
	var obj_data_internal = jQuery('.ngeinternalform');

//    	 var obj_data_params =  	jQuery('form[name=optionsform]');
//    	 var obj_data_display =  	jQuery('form[name=displayform]');

	var str_data_content = JSON.stringify(obj_data_content.serialize());
	var str_data_params = JSON.stringify(obj_data_params.serialize());
	var str_data_display = JSON.stringify(obj_data_display.serialize());
	var str_data_access = JSON.stringify(obj_data_access.serialize());
	var str_data_internal = JSON.stringify(obj_data_internal.serialize());

	str_data_content = str_data_content.replace(/\"/g, "");
	str_data_params = str_data_params.replace(/\"/g, "");
	str_data_display = str_data_display.replace(/\"/g, "");	
	str_data_access = str_data_access.replace(/\"/g, "");
	str_data_internal = str_data_internal.replace(/\"/g, "");
	var data = {'ngecontent': str_data_content, 'ngeparams': str_data_params, 'ngedisplay': str_data_display, 'ngeinternal': str_data_internal, 'ngeaccess': str_data_access};
	data['<?php echo NGE::token(); ?>'] = 1;
	jQuery.ajax({
	    url: "<?php echo juri::base() ?>index.php?option=com_nge&task=part.save"+pkUrl,
			data: data,
			async: false,
			type: 'POST',
			success: function (result) {
			    try {
				var result_obj = jQuery.parseJSON(result);
			    }
			    catch(error){
				console.log(error);
				console.log(result);
			    }
			    if (result_obj.result == '0') {
				alert(result_obj.message);
			    }
			    else { // error > 0 == pas d'erreur

				switch (caller){
				    case 'tinymce' :
				    case 'jce' :
					window.top.pkid = result_obj.htmlspan;
					window.top.htmlpart = result_obj.htmlpart;
					$editors = array('tinymce', 'jce', 'jck');
					try {
					    parentWin = (!window.frameElement && window.dialogArguments) || opener || parent || top;
					    tinymce = parentWin.tinymce;
					    editor = tinymce.EditorManager.activeEditor;
					    params = self.editor.windowManager.getParams();
					    editor.windowManager.close(window);
					}
					catch (e) {
					    console.error('ERROR WHILE SAVING');
					}
					break;
				    case 'jck':
				    case 'ckeditor':
					window.top.pkid = result_obj.htmlspan;
					window.top.htmlpart = result_obj.htmlpart;
					break;
				    case 'ckeditor.inline' :
					window.top.result_obj = result_obj;
					break;
				    case 'front' :
					/*afterLayoutPartCreate & afterLayoutPartUpdate are created on editor/mainbar/editor.mainbar.js*/
					if (mode == 'create')
					    window.parent.document.afterLayoutPartCreate(result_obj);
					else
					    window.parent.document.afterLayoutPartUpdate(result_obj);
					break;
				    case 'ngepart' :
					if (mode == 'create')
					    window.parent.document.afterLayoutPartCreate(result_obj.pk, result_obj.plname);
					else
					    window.parent.document.afterLayoutPartUpdate(result_obj.pk, result_obj.plname);
					break;
				    default :
					if (caller.substring(0, 6) == 'layout') {
					    /*afterLayoutPartCreate & afterLayoutPartUpdate are created on editor/mainbar/editor.mainbar.js*/
					    if (mode == 'create')
						window.parent.document.afterLayoutPartCreate(result_obj);
					    else
						window.parent.document.afterLayoutPartUpdate(result_obj);
					}
					else
					    top.location.reload();
				}
			    }
			},
			error: function (result) {
			    showMessage('Error', 'Error while saving part. Please try again.');
			}

		    });

	<?php endif; ?>

    }

    function loadLibrary() {
	var url = "<?php echo juri::base() ?>index.php?option=com_nge&view=librarygallery&format=raw&caller="+caller;
	if (caller != 'jce'){
		document.location.href = url;
	}
	else {
		jQuery("#easypartdialog").html('<div style="text-align:center;margin-top:50px;"><img src="<?php echo JUri::root() ?>components/com_nge/assets/images/spinner.gif" /></div>');
		jQuery.ajax({
		    url: url,
		    success: function (result) {
			jQuery("#easypartdialog").html(result);
		    }
		});
	}
    }

    function loadLibraryCategory(categoryId, categoryName) {
	var url = "<?php echo juri::base() ?>index.php?option=com_nge&view=librarygallery&format=raw&caller="+caller+"&category_id=" + categoryId + "&category_name=" + categoryName;
	if (caller != 'jce'){
	    document.location.href = url;
	}
	else{
	    jQuery("#easypartdialog").html('<div style="text-align:center;margin-top:50px;"><img src="<?php echo JUri::root() ?>components/com_nge/assets/images/spinner.gif" /></div>');
	    jQuery.ajax({
		url: url,
		success: function (result) {
		    jQuery("#easypartdialog").html(result);
		}
	    });
	}
    }

    var storeWidth = "";
    function hideConfig(){
        storeWidth = jQuery("#nge-config-preview").css("flex-basis");
	jQuery('#nge-config-form').hide();
        jQuery("#nge-config-preview").css({
            "-webkit-flex": "1 0 auto",
            "-ms-flex": "1 0 auto",
            "flex": "1 0 auto",
            "left": "0"
        });
    }
    
    function showConfig(){
	
        jQuery("#nge-config-preview").removeAttr("style").css({
            "-webkit-flex": "0 0 "+storeWidth+"px",
            "-ms-flex": "0 0 "+storeWidth+"px",
            "flex": "0 0 "+storeWidth+"px",
            "left": "0"
        });
	jQuery('#nge-config-form').show();
    }

    function setContent($html) {
        jQuery("#ngeconfigbody").html($html);
    }

    function loadContent($url) {
    
        var loaderHtml = '<div align="center" class="nge-loading1" style="zoom:1.8;">'
                    + '<div class="nge-loading1-container-general">'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_1"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_2"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_3"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_4"> </div></div>'
                    + '</div>'
                + '</div>';
        jQuery("#ngeconfigbody").html(loaderHtml);
	previewInitpageLoaded = false;
	previewIsLoading = false;

        jQuery.ajax({
            url: $url,
            async: true,
            type: 'POST',
            success: function ($result) {
                jQuery.when(
                    jQuery("#ngeconfigbody").hide(),
                    jQuery("#ngeconfigbody").html($result),	
	    initParents(),
                    initFields()
                ).done(function() {
                    initConfigEvent();
		    jQuery('#nge-config-form').niceScroll({cursorcolor: "#abb0c7", 
			autohidemode: "leave", 
			cursorborder : "none", 
			cursorwidth: "10px", 
			background:"rgba(20,20,20,0.3)",
			cursoropacitymin: 0.3, 
			cursoropacitymax: 0.9 });
		    
                    jQuery("#ngeconfigbody").fadeIn();
                });
            },
            error: function (result) {
                showMessage('Error', 'Error while loading config. Please try again.');
            }

        });

    }
    
    function saveConfig() {
        ///If demo Mode : alert and no save

        //Updating tinymce editor instances
        try {
            if (!(typeof tinymce === "undefined") && !(tinymce == null)) {
                for (var i = 0; i < tinymce.editors.length; i++) {
                    tinymce.editors[i].save();
                }
            }
        }
        catch (e) {
            console.error('error while saving tinyMCE editor : ' + e.message)
        }

        // update ckeditor instances
        try {
            if (typeof CKEDITOR !== 'undefined') {
                CKEDITOR = window.CKEDITOR;
                for (var id in CKEDITOR.instances) {
                    CKEDITOR.instances[id].updateElement();
                }
            }
        }
        catch (e) {
            console.error('error while saving CkEditor editor : ' + e.message)
        }

        // separate content and params
        //Content will be saved in the content field, and params in the params field         
        //var obj_data_content = jQuery('#contentform');
        var obj_data_content = jQuery('.ngecontentform');
        //var obj_data_params = jQuery('#optionsform');
        var obj_data_params = jQuery('.ngeoptionsform');
        var obj_data_display = jQuery('.ngedisplayform');
        var obj_data_internal = jQuery('.ngeinternalform');

        var str_data_content = JSON.stringify(obj_data_content.serialize());
        var str_data_params = JSON.stringify(obj_data_params.serialize());
        var str_data_display = JSON.stringify(obj_data_display.serialize());
        var str_data_internal = JSON.stringify(obj_data_internal.serialize());

        str_data_content = str_data_content.replace(/\"/g, "");
        str_data_params = str_data_params.replace(/\"/g, "");
        str_data_display = str_data_display.replace(/\"/g, "");
        str_data_internal = str_data_internal.replace(/\"/g, "");
        var data = {'ngecontent': str_data_content, 'ngeparams': str_data_params, 'ngedisplay': str_data_display, 'ngeinternal': str_data_internal};
        data['<?php echo NGE::token(); ?>'] = 1;

        jQuery.ajax({
            url: "<?php echo juri::base() ?>index.php?option=com_nge&task=inline.storeconfig",
                        data: data,
                        async: false,
                        type: 'POST',
                        success: function (result) {
                            var result_obj = jQuery.parseJSON(result);
                            if (result_obj.result == '0') {
                                alert(result_obj.message);
                            }
                            else { // error > 0 == pas d'erreur
        <?php

        //    if (($this->caller == 'front') || (substr($this->caller, 0, 6) == 'layout')) {
        /*afterLayoutPartCreate & afterLayoutPartUpdate are created on editor/mainbar/editor.mainbar.js*/
        //  	    echo "window.parent.document.afterLayoutPartUpdate(result_obj);";
        //}
        ?>
                            }
                        },
                        error: function (result) {
                            showMessage('Error', 'Error while saving part. Please try again.');
                        }
        });
    }
    
    var ngeDelayDialog = (function () {
	    "use strict";
		var elem,
		    hideHandler,
		    that = {};

	    that.init = function (options) {
		that.elem = jQuery(options.selector);
	    };

	    that.show = function (text) {
		clearTimeout(hideHandler);

		that.elem.find("span").html(text);
		that.elem.delay(200).fadeIn().delay(4000).fadeOut();
	    };

	    return that;
    }());
    
    initParents = function(){
	if (caller == 'tinymce'){
	    /*alert("tinymce");*/
	    /*alert(jQuery(window.parent.document).find(".mce-window-head").html());*/
	    var $mceContainer = jQuery(window.parent.document).find(".mce-window");	    
	    $mceContainer.css("border", "none");
	    $mceContainer.attr('style', $mceContainer.attr('style') + '; ' + 'padding: 0px !important;');
	    jQuery(window.parent.document).find(".mce-window-head").hide();
	}
	else
	if (caller == 'jck'){
	    jQuery(window.parent.document).find(".cke_dialog_title").hide();
	    jQuery(window.parent.document).find(".cke_dialog_body").css("padding", "0px");
	    jQuery(window.parent.document).find(".cke_dialog_contents").css("padding", "0px");
	    jQuery(window.parent.document).find(".cke_dialog_ui_vbox_child ").css("background", "#555D83");		
	}
	else
	if (caller =='jce'){
	    jQuery(window.parent.document).find(".mce-windows-head").hide();
	    jQuery(window.parent.document).find(".mceModalHeader").hide();
	    jQuery(window.parent.document).find(".ui-dialog-titlebar").hide();
	    jQuery(".mceActionPanel").hide();
	    jQuery(window.parent.document).find(".mceModalBody").css("max-width", "100%");
	    jQuery(window.parent.document).find(".mceModalContent").css("height", "100%");
	}
    }
        
    initConfigEvent = function(){
        var parentWidth;	

	
	/* Main tab events */
    
    jQuery('#headergallery').find('a[data-toggle="tab"]').on('shown', function (e) {
	
	/* If tag is empty, the form is loaded in ajax mode (performance */	
	var $targetDiv = jQuery(e.target.attributes.href.value);
	if ($targetDiv.html() == ''){	    
	    var formForm = $targetDiv.attr('data-form');
	    var formMode = $targetDiv.attr('data-mode');
	    if (formMode == 'create')
		var key = 'plname=' + $targetDiv.attr('data-pk');
	    else
		var key = 'pk=' + $targetDiv.attr('data-pk');
	var loaderHtml = '<div align="center" class="nge-loading1" style="zoom:1.8;">'
                    + '<div class="nge-loading1-container-general">'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_1"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_2"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_3"> </div></div>'
                        + '<div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_4"> </div></div>'
                    + '</div>'
                + '</div>';   
	$targetDiv.html(loaderHtml);
	    jQuery.ajax({
		url: "<?php echo NGEURL_BASE; ?>index.php?option=com_nge&view=config&layout=subform&mode=" + formMode + "&format=raw&caller=config&" + key + "&form="+formForm,
		type: 'POST',
		success: function (result) { 
		    $targetDiv.html(result);
		    initFields($targetDiv);
		}
	    });
	    
	}	
  })
	
	/* Config windows resize*/
        jQuery("#nge-config-preview").resizable({
            handles: "w",
            start: function(event, ui){
                parentWidth = jQuery("#nge-config-preview").parent().width();
                /*add a mask over the Iframe to prevent navigator from stealing mouse events*/
                jQuery("#nge-config-preview").append('<div id="mask" style="position: absolute; z-index: 2; left: 0pt; top: 0pt; right: 0pt; bottom: 0pt;"></div>')
            },
            resize: function( event, ui ){
                var previewWidth = jQuery("#nge-config-preview").width();
                var configWidth = jQuery("#nge-config-form").width();
                var resWidth = ui.size.width;
                
                if(previewWidth + configWidth > parentWidth){
                    if(previewWidth > configWidth){
                        resWidth = parentWidth - configWidth;
                    }else{
                        resWidth = parentWidth - previewWidth;
                    }
                }else if(previewWidth < 250){
                    resWidth = 250;
                }else if(configWidth < 250){
                    resWidth = parentWidth - 250;
                }else{
                    jQuery("#nge-config-preview").css('width', '');
                    jQuery("#nge-config-preview").css({
                        "-webkit-flex": "0 0 "+resWidth+"px",
                        "-ms-flex": "0 0 "+resWidth+"px",
                        "flex": "0 0 "+resWidth+"px",
                        "left": "0"
                    });
                }
            },
            stop: function(event, ui) {
                var previewWidth = jQuery("#nge-config-preview").width();
                var configWidth = jQuery("#nge-config-form").outerWidth();
                var resWidth = ui.size.width;

                if(previewWidth + configWidth > parentWidth){
                    if(previewWidth > configWidth){
                        resWidth = parentWidth - configWidth;
                    }else{
                        resWidth = parentWidth - previewWidth;
                    }
                }else if(previewWidth < 250){
                    resWidth = 250;
                }else if(configWidth < 250){
                    resWidth = parentWidth - 250;
                }
                
                jQuery("#nge-config-preview").css('width', '');
                jQuery("#nge-config-preview").css({
                    "-webkit-flex": "0 0 "+resWidth+"px",
                    "-ms-flex": "0 0 "+resWidth+"px",
                    "flex": "0 0 "+resWidth+"px",
                    "left": "0"
                });
                /*remove mask when dragging ends*/
                jQuery("#mask").remove();
            }
        });
    }
        ngeDelayDialog.init({
	    "selector": ".bb-alert"
	});
        
    //Trigger in the main screen that all scripts in the config form are ready. Part toolbar becomes available
    if (typeof parent.onConfigFormReady === "function")
	parent.onConfigFormReady(); 
 
    /**
     * Function to send Permissions via Ajax to Com-Config Application Controller
     * impossible in front, then function return only true
     */
    function sendPermissions(event) {
        return true;
    }
</script>