CREATE TABLE IF NOT EXISTS `#__nge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `params` text DEFAULT NULL,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`plugin`,`published`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`name`)
);

INSERT IGNORE INTO  `#__nge_categories` (
`id` ,`parent_id` ,`lft` ,`rgt` ,`level` ,`plugin` ,`title` ,`name` ,`description` ,`published` ,`access` ,`params` ,`created_time` ,`modified_time`)
VALUES ('1',  '0',  '0',  '0',  '0',  '',  'ROOT',  'root',  '',  '1',  '2', NULL ,  NOW(),  NOW());

CREATE TABLE IF NOT EXISTS `#__nge_items` (
  `id` varchar(127) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `item` varchar(127) NOT NULL,
  `selector` varchar(255) DEFAULT NULL,
  `params` text NOT NULL,
  `html` text,
  `css` text,
  `js` text,
  `modified` DATETIME NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NULL,
  PRIMARY KEY (`id`)
);

CREATE TABLE IF NOT EXISTS `#__nge_parts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `part` varchar(127) NOT NULL,
  `content` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `html` mediumtext,
  `css` mediumtext,
  `js` mediumtext,
  `thumbnail` mediumtext,
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL,
  `hits` int(10) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `checked_out` int(11) DEFAULT NULL,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL,
  `modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` INT(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
);

CREATE TABLE IF NOT EXISTS `#__nge_parts_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `part_id` int(11) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `part` varchar(127) NULL,
  `content` mediumtext NULL,
  `params` mediumtext NULL, 
  `language` char(7) NOT NULL,
  `created` DATETIME NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NULL,
  `modified` DATETIME NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` INT(10) NULL DEFAULT '0',
  PRIMARY KEY (`id`),
    UNIQUE KEY `part` (`part_id`,`modified`)
);

CREATE TABLE IF NOT EXISTS `#__nge_parts_library` (
  `part` varchar(127) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `ordering` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `content` text NULL,
  `params` text NULL,
  `access` int(10) NOT NULL DEFAULT '2',
  `checked_out` int(11) DEFAULT NULL,
  `checked_out_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `demo_link` varchar(250) DEFAULT NULL,
  `preview_width` tinyint(4) DEFAULT NULL,
  `state` int(5) NOT NULL DEFAULT '1',
  PRIMARY KEY (`part`)
);

CREATE TABLE IF NOT EXISTS `#__nge_patterns` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `content` mediumtext NULL,
  `params` text NULL,
  `settings` text NULL,
  `thumbnail` mediumtext NULL,
  `ordering` int(11) NULL,
  `state` tinyint(1) NOT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `typename` (`type`,`name`)
);

CREATE TABLE IF NOT EXISTS `#__nge_plugins` (
  `name` varchar(127) NOT NULL,
  `title` varchar(255) NOT NULL,
  `ordering` SMALLINT(4) NULL,
  `type` varchar(127) NOT NULL DEFAULT 'pack',
  `params` text,
  `version` varchar(10) DEFAULT NULL,
  `created_datetime` datetime NOT NULL,
  PRIMARY KEY (`name`)
);
