<?php
/**
 * This file is part of Nge
 *
 * @version     1.0
 * @package		Nge
 * @copyright	Copyright (C) 2014 TEATIS. All rights reserved.
 * @license		GNU/GPL, see LICENSE.txt
 * NextGenEditor is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses.
 *
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
    
jimport('joomla.filesystem.file');


class com_ngeInstallerScript
{
    private $previousVersion=0;
    
    
    /**
     * method called before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent)
    {
        
	$db = JFactory::getDbo();
	$sql = 'SELECT manifest_cache FROM #__extensions WHERE name="com_nge"';
	$db->setQuery($sql);
	$comNgeManifestJson = $db->loadResult();
	if($comNgeManifestJson !='') {
	    $comNgeManifest = json_decode($comNgeManifestJson);
		$this->previousVersion = $comNgeManifest->version;

	}

	if($type == 'install' || $type == 'update') {
	// compare current version with 1.1.0 for :
	    //delete layout folder if under
	    // delete nge pack reference in nge_plugins table
	    // delete part cache in nge_parts table

		if ($this->previousVersion){
		    //Before 1.1.0
		    if(version_compare($this->previousVersion,'1.1.0')<0 ) {

		// delete old packs (version <= 1.0.2 : plugins content,media, navigation
		$sql = 'DELETE FROM #__nge_plugins WHERE name IN ("content","media","navigation") ';
		$db->setQuery( $sql) ;
		$db->execute();

		// 1.0.3 delete old pack language file
		$oldPacks = array('content','media','navigation');
		foreach($oldPacks as $k=>$pack) {
		    // del en file
		    $en_filename = JPATH_SITE.'/language/en-GB/en-GB.com_nge_'.$pack.'.ini';
		    if(file_exists($en_filename))
			JFile::delete($en_filename);
		    // del fr file
		    $fr_filename = JPATH_SITE.'/language/fr-FR/fr-FR.com_nge_'.$pack.'.ini';
		    if(file_exists($fr_filename))
			JFile::delete($fr_filename);

		}		
		    }
		    else //1.1.0 and upper
		    if(version_compare($this->previousVersion,'1.1.0')>0 ) {
		    }	    
		}
	 }
	 
	//Removing old files
	 //Called here in preflight
	 //Delete all deprecated files. But if there are some new files with the same name, they will be anyway created within the new installation
	if ($type == 'update'){
	       $this->deleteUnexistingFiles();
	}
	 
    }

    
    
    /**
     * method called while the first install of the component
     *
     * @return void
     */
    function install($parent)
    {
	// install current editors addons : Tinymce, Jce, Jck
	// Not ARK (external plugin)
	$this->installEditorsAddons();
	
	//Default assets for editing features
	$this->createDefaultAssets();
   }

   /**
     * method called while an update of the component
     *
     * @return void
     */
    function update($parent)
    {
	// install current editors addons : Tinymce, Jce, Jck
	// Not ARK (external plugin)
	$this->installEditorsAddons();

	//Update database fields
	$this->updateDatabase($parent);	
	
	//clear caches
	$this->clearCache();
	
	//Fix extant manual assets
	$this->fixManualAssets();
	
	//Default assets for editing features
	$this->createDefaultAssets();	
    }
   
    /**
     * method called while the component is uninstalled
     *
     * @return void
     */
    function uninstall($parent)
    {        
	//Uninstall all editors addons
	$this->uninstallEditorsAddons();

	//Included packs are allready deleted in the component directories	
	
	// Delete layout folder that is external to the component
	//Is deleted by the package uninstall, but must be called here if component is uninstalled alone
	if (is_dir(JPATH_SITE.'/layouts/nge'))
	    JFolder::delete(JPATH_SITE.'/layouts/nge');
		
	// clean nge admin cache
	$conf = JFactory::getConfig();
	$optionsAdmin = array(
		'defaultgroup' => '',
		'storage'      => $conf->get('cache_handler', ''),
		'caching'      => true,
		'cachebase'    => JPATH_ADMINISTRATOR . '/cache'
	);
	$cacheAdmin = JCache::getInstance('', $optionsAdmin);
	$cacheAdmin->clean('com_nge'); 

	// clean nge front cache
	$optionsFront = array(
		'defaultgroup' => '',
		'storage'      => $conf->get('cache_handler', ''),
		'caching'      => true,
		'cachebase'    => $conf->get('cache_path', JPATH_SITE . '/cache')
	);
	$cacheFront = JCache::getInstance('', $optionsFront);
	$cacheFront->clean('com_nge'); 		
	
    }
    
    /**
     * method called after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent)
    {

	$t = $parent->getParent()->getManifest();
	$currentVersion = $t->version;	
	
	$db = JFactory::getDbo();
	
	if($type == 'uninstall') {
		// remove #__shemas record of the nge component
	    $sql = 'DELETE FROM #__schemas WHERE extension_id= (SELECT extension_id FROM #__extensions WHERE name="com_nge")';
	    $db = JFactory::getDbo();
	    $db->setQuery($sql);
	    $db->execute();	    
    	    
	}
	else	
	if($type == 'install' || $type == 'update') {
						
	    // update table #__schemas
	    $db = JFactory::getDbo();
	    $sql = 'SELECT count(*) FROM  #__schemas WHERE extension_id=(SELECT extension_id FROM #__extensions WHERE name="com_nge")';
	    $db->setQuery($sql);
	    $ngeComponentExists = $db->loadResult();

	    if($ngeComponentExists>0) {
		$sql = 'UPDATE #__schemas SET version_id="'.$currentVersion.'" WHERE extension_id= (SELECT extension_id FROM #__extensions WHERE name="com_nge")';
	    }
	    else {
		$sql = 'INSERT INTO #__schemas (extension_id,version_id) VALUES ((SELECT extension_id FROM #__extensions WHERE name="com_nge"),"'.$currentVersion.'")';
	    }
	    $db->setQuery($sql);
	    $db->execute();
        
	    // install all packs included in the component admin/packs directory
	    $this->installIncludedPacks($parent);

	    //Create cache directory. Used for elfinder cached images
	    if(!is_dir(JPATH_ROOT . "/cache/nge/elfinder")){
		jimport('joomla.filesystem.folder');
		JFolder::create(JPATH_ROOT . "/cache/nge/elfinder");
	    }
	    //If directory not created, display a message to the user, especially with admintools
	    //Admin Tools : it seems that during the installation of an extension we can access all directories
	    //If it is the case, the following lines about Admin Tools are not usefull.. 
	    if(!is_dir(JPATH_ROOT . "/cache/nge/elfinder")){
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_CACHEDIRECTORY_ERROR1') . '<br/>'
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ERROR2') . '<br/><br/>' 
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS1') . '<br/>'
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS2') . '<br/>'
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS3') . '<br/>'
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS4') . '<br/>'
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS5') . '<br/>'		
		. JText::_('NGE_INSTALLER_CACHEDIRECTORY_ADMINTOOLS6')
		, 'warning');
	    }
	                
	    // update version of the "core plugin" to the version number of the nge component
	    $sql = 'UPDATE #__nge_plugins SET version= "'.$currentVersion.'" WHERE name="core" ';
	    $db = JFactory::getDbo();
	    $db->setQuery($sql);
	    $db->execute();
                        
	    //End of installation
	    $app = JFactory::getApplication();
	    $lang = JFactory::getLanguage();
	    $lang->load('com_nge');

	    //Displaying postinstall screen
	    $parent->getParent()->setRedirectURL('index.php?option=com_nge&view=cpanel&layout=afterinstall');
	}     
     }
    
     /**
      * Install widgets packs included in the component, in the admin/packs directory : core pack and other packs.
      * @param type $parent
      */
    private function installIncludedPacks($parent) {

	include(JPATH_ADMINISTRATOR.'/components/com_nge/models/install.php');
	$installModel = JModelLegacy::getInstance('Install','NgeModel');

	// save curent $_request values
	$jinput = JFactory::getApplication()->input;
	$currentJinput = $jinput->serialize();
		
	// execute installation of each included pack
	$includedPacksPath = JPATH_ADMINISTRATOR.'/components/com_nge/packs';

	//Reading all sub directories in the admin/packs directory : one subdirectory for each pack
	$includedPacks = array();
	if(is_dir($includedPacksPath))
	     $includedPacks = JFolder::folders($includedPacksPath);
	
	    // set $_request values for installing pack
	    $jinput->set('option','com_nge');
	    $jinput->set('view','install');
	    $jinput->set('installtype','folder');
	    $jinput->set('task','install');
	
		
	foreach($includedPacks as $pack) {

	    $jinput->set('install_directory', $includedPacksPath.'/'.$pack);

	    // execute pack installation as if it where from the joomla install screen
	    $installModel->install();

	}
	//Restore previous Jinput
	$jinput->unserialize($currentJinput);

	//After install, remove the included packs files
	if(is_dir($includedPacksPath))
		JFolder::delete($includedPacksPath);
        
    }
    
    
    /**
     * Install addons far all current editors in Joomla
     */
    private function installEditorsAddons() {

	JFactory::getLanguage()->load('com_nge');
	
	//Getting installed addons
	JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_nge/models');
	$cpanelModel = JModelLegacy::getInstance('Cpanel','NgeModel');		
	$ngeplugins = $cpanelModel->getPluginsParams();
		
	// TINYMCE
	// if nge plugin for tinyMCE already installed, only copy files, else, copy and declare plugin
	$tinymce = $ngeplugins['tinymce'];
	if( $tinymce->isInstalled && file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.tinymce.php')) {
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.tinymce.php');
		if (ngeHelperTinymceInstaller::installAddon($tinymce->isNgeMissing))
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_TINYMCE_INSTALL_OK'));	
	}

	// JCE
	// if nge plugin for JCE already install, only copy files, else, copy and declare plugin
	$jce = $ngeplugins['jce'];
	if( $jce->isInstalled  && file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php')) {
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php');
		if (ngeHelperJceInstaller::installAddon($jce->isNgeMissing))
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCE_INSTALL_OK'));	
	}

	// JCK Editor
	// if nge plugin for JCK already install, only copy files, else, copy and declare plugin
	$jck = $ngeplugins['jckeditor'];
	if( $jck->isInstalled  && file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php')) {
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php');
		if (ngeHelperJckInstaller::installAddon($jck->isNgeMissing))		
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_INSTALL_OK'));	
	}
	
	// ARK Editor
	//To be installed manually as a Joomla extension
				
    }
    
      /**
      * clear all caches for NGE
      */
    private function clearCache() {
	
	// clean nge admin cache
	$conf = JFactory::getConfig();
	$optionsAdmin = array(
		'defaultgroup' => '',
		'storage'      => $conf->get('cache_handler', ''),
		'caching'      => true,
		'cachebase'    => JPATH_ADMINISTRATOR . '/cache'
	);
	$cacheAdmin = JCache::getInstance('', $optionsAdmin);
	$cacheAdmin->clean('com_nge'); 

	// clean nge front cache
	$optionsFront = array(
		'defaultgroup' => '',
		'storage'      => $conf->get('cache_handler', ''),
		'caching'      => true,
		'cachebase'    => $conf->get('cache_path', JPATH_SITE . '/cache')
	);
	$cacheFront = JCache::getInstance('', $optionsFront);
	$cacheFront->clean('com_nge'); 		

	//Clean parts cache
	$db = JFactory::getDbo();
	$sql = "UPDATE #__nge_parts SET css='', js=''";
	$db->setQuery( $sql) ;
	$db->execute();
	
    }
    
    /**
     * Uninstalll addons for all current editors in Joomla
     */
    private function uninstallEditorsAddons() {

	// TINYMCE
	if (file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.tinymce.php')){
	    require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.tinymce.php');
	    ngeHelperTinymceInstaller::uninstallAddon();
	}

	// JCE
	if (file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php')){
	    require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php');
	    ngeHelperJceInstaller::uninstallAddon();
	}

	// JCK Editor
	if (file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php')){
	    require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php');
	    ngeHelperJckInstaller::uninstallAddon();
	}
    }    
    
    
    /**
     * Delete old files that no longer exists in the current version
     *
     * @return  void
     */
    private function deleteUnexistingFiles()
    {
	    $files = array(
		    //1.1.0
		    '/components/com_nge/controllers/xeditable.php',
		    '/components/com_nge/helpers/api/_listitems.php',
		    '/components/com_nge/helpers/api/_ngehelper.php',
		    '/components/com_nge/helpers/api/_sizemarginobject.php',		    
		    '/components/com_nge/helpers/editor/editor.php',
		    '/components/com_nge/helpers/editor/editor_workshop.php',
		    '/components/com_nge/models/xeditable.php',
		    '/language/en-GB/en-GB.com_nge_content.ini',
		    '/layouts/nge/panels/thumbnails.php',
		    '/media/com_nge/elfinder/MISE_A_JOUR.txt',
		    '/media/com_nge/icomoon/MISE_A_JOUR.txt',
		    //2.0.0
		    '/components/com_nge/helpers/api/backgroundoverflow.php',
		    //2.2.0
		    '/administrator/components/com_nge/controllers/layout.php',
		    '/administrator/components/com_nge/models/forms/_parts.xml',
		    '/components/com_nge/controllers/article.php',
		    '/components/com_nge/controllers/layout.php',
		    '/components/com_nge/helpers/editor/mainbar/_editor.mainbar.php',		
		    '/components/com_nge/helpers/forms/select/k2select.php',
		    '/components/com_nge/helpers/parts/renderer/generate.php',
		    '/components/com_nge/parts/navigation/button/DEV_toolbar.php',
		    '/components/com_nge/parts/panels/panel/_create.php',
		    '/components/com_nge/parts/panels/tabs/_create.php',
		    '/components/com_nge/parts/panels/carousel/config.xml',
		    '/components/com_nge/parts/text/title/_create.php',
		    '/components/com_nge/views/config/view.html.php',		
		    '/layouts/nge/parts/menus/_dropdown.php',
		    '/layouts/nge/parts/menus/_menu.php',
		    '/layouts/nge/parts/menus/slider.php',
		    '/layouts/nge/parts/menus/xdropdown.php',
		    '/media/com_nge/elfinder/.gitignore',
		    '/media/com_nge/elfinder/elfinder.html',
		    '/media/com_nge/elfinder/elfinder.php',
		    '/media/com_nge/elfinder/Changelog',
		    '/media/com_nge/elfinder/bower.json',
		    '/media/com_nge/elfinder/composer.json',	
		    '/media/com_nge/elfinder/main.default.js',
		    '/media/com_nge/elfinder/README.md',
		    '/media/com_nge/elfinder/package.json',		
		    '/media/com_nge/elfinder/css/elfinder.full.css',
		    '/media/com_nge/elfinder/js/elfinder.full.js',
		    '/media/com_nge/elfinder/php/MySQLStorage.sql',
		    '/media/com_nge/elfinder/php/MySQLStorage.sql',
		    '/media/com_nge/elfinder/php/connector.minimal.php',
		    '/media/com_nge/elfinder/php/connector.php-dist',
		    '/media/com_nge/elfinder/php/elFinderFlysystemGoogleDriveNetmount.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeBox.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeDropbox.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeDropbox2.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeFTP.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeGoogleDrive.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeMySQL.class.php',
		    '/media/com_nge/elfinder/php/elFinderVolumeOneDrive.class.php',
		    '/media/com_nge/icomoon/selection.json',
		    '/media/com_nge/jquery/_jquery.min.js',
		    '/media/com_nge/jquery/jquery-1.9.1.min.js',
		    '/media/com_nge/jquery/jquery-1.11.3.js',
		    '/media/com_nge/slick/ajax-loader.gif',
		    '/media/com_nge/slick/config.rb',
		    '/media/com_nge/slick/slick-theme.less',
		    '/media/com_nge/slick/slick-theme.scss',
		    '/media/com_nge/slick/slick.less',
		    '/media/com_nge/slick/slick.scss',
	    );

	    $folders = array(
		    //1.1.0
		    '/components/com_nge/classes/frontediting',
		    '/components/com_nge/helpers/documents',
		    '/components/com_nge/helpers/metaform',
		    '/components/com_nge/models/fields',
		    '/components/com_nge/models/forms',
		    '/components/com_nge/parts/nge/config',
		    '/components/com_nge/parts/panels/thumbnails',
		    '/components/com_nge/views/xcontent',
		    '/layouts/parts',
		    '/media/com_nge/datatables',
		    '/media/com_nge/jshrink',
		    '/media/com_nge/jssor',
		    '/media/com_nge/requirejs',
		    '/media/com_nge/x-editable',
		    //2.2.0
		    '/administrator/components/com_nge/views/editor',
		    '/components/com_nge/contents/source/_images',
		    '/components/com_nge/contents/source/database',
		    '/components/com_nge/contents/source/query',
		    '/components/com_nge/contents/source/sample',
		    '/components/com_nge/contents/source/stockexchange',
		    '/components/com_nge/helpers/api/part/panels/_thumbnails',
		    '/components/com_nge/helpers/data/_database',
		    '/components/com_nge/helpers/data/teatis',
		    '/components/com_nge/parts/galleries',
		    '/components/com_nge/parts/images/image/wizards',
		    /*To be kept for old users using that part '/components/com_nge/parts/images/tabs',*/
		    '/components/com_nge/parts/navigation/_menu',
		    '/components/com_nge/parts/navigation/button/wizards',
		    '/components/com_nge/parts/popups',
		    '/components/com_nge/parts/text/iframe',
		    '/components/com_nge/views/_widget',		
		    '/components/com_nge/views/contentsource',
		    '/components/com_nge/views/editor',
		    '/components/com_nge/views/inlineeditor',		
		    '/components/com_nge/views/gallery',
		    '/media/com_nge/bootstrap-modal',
		    '/media/com_nge/elfinder/files',
		    '/media/com_nge/magnific-popup',
		    '/media/com_nge/sortable/st',
		
	    );

	    jimport('joomla.filesystem.file');

	    foreach ($files as $file)
	    {
		    if (JFile::exists(JPATH_ROOT . $file) && !JFile::delete(JPATH_ROOT . $file))
		    {
			    echo JText::sprintf('FILES_JOOMLA_ERROR_FILE_FOLDER', $file) . '<br />';
		    }
	    }

	    jimport('joomla.filesystem.folder');

	    foreach ($folders as $folder)
	    {
		    if (JFolder::exists(JPATH_ROOT . $folder) && !JFolder::delete(JPATH_ROOT . $folder))
		    {
			    echo JText::sprintf('FILES_JOOMLA_ERROR_FILE_FOLDER', $folder) . '<br />';
		    }
	    }
    }
    
    
    /**
     * Update database commands
     * Executing the sql update commands in the update .sql files, starting with #EXEC_NOERROR:
     * Using this feature for SQL commands allows to trap errors.
     * For example launch alter table add field command even if it already exists
     * So we can reinstall many times our extension in case of previous installation problems
     * 
     * Take care : all commands with #EXEC_NOERROR are executed after all other commands
     *
     * @return  void
     */
    private function updateDatabase($parent)
    {
        	$db = JFactory::getDbo();
	
	$manifest = $parent->getParent()->getManifest();
	$newVersion = $manifest->version;		
	$updatesDirectory = JPATH_ADMINISTRATOR . '/components/com_nge/sql/updates/mysql';
	jimport('joomla.filesystem.folder');
	$updateFiles = JFolder::files($updatesDirectory, $filter = '.sql');
	foreach ($updateFiles as $fileName){
	    $fileVersion = substr($fileName, 0, -4);
	    //If installed version before, executing file content
	    if ((version_compare($this->previousVersion, $fileVersion) <0) || ($fileVersion == $newVersion)){
		$handle = fopen($updatesDirectory . '/' . $fileName, "r");
		if ($handle) {
		    while (($line = fgets($handle)) !== false) {
			if (strtoupper(substr($line, 0, 14)) == '#EXEC_NOERROR:'){
			    $sql = substr($line, 14);
			    try {
				$db->setQuery($sql);
				$db->execute();
				
			    } catch (Exception $ex) {
				JFactory::getApplication()->enqueueMessage('This command has not been executed. It was already done.<br/>'.$sql, 'notice');
			    }
			}
			// process the line read.
		    }
		    fclose($handle);
		} else {
		    echo NGE::TRANSLATE('NGE_ERROR_READING FILE') .  ' :  ' . $fileName . '<br />';
		} 
	    }
	    
	}
	
    }	
    
    /**
     * Fix previous manual assets
     * @return boolean
     */
    private function fixManualAssets(){
	
	//Remove existing manual asset record for NGE. Added in 1.1.2. by direct SQL script. Can break any admin login in Joomla
	//when uninstall NGE, com_admin record (lft=1) also removed by Joomla
	$db = JFactory::getDbo();
	$sql = 'SELECT rules FROM #__assets WHERE name="com_nge" AND lft=1';
    	$db->setQuery($sql);
	$extantRules = $db->loadResult();
	if ($extantRules != false){
	    $sql = 'DELETE FROM #__assets WHERE name="com_nge" AND lft=1';
	    $db->setQuery( $sql) ;
	    $db->execute();
	    
	    $asset = JTable::getInstance('Asset');
	    $asset->name      = 'com_nge';
	    $asset->parent_id = 1;
	    $asset->rules     = $extantRules;
	    $asset->title     = 'com_nge';
	    $asset->setLocation(1, 'last-child');
	    if (!$asset->store()){
		    JFactory::getApplication()->enqueueMessage('Error while fixing extant assets.<br/>'.$sql, 'warning');
	    }
	}
	return true;
    }
    
    /**
     * Create default assets for all NGE features
     * @return boolean
     */
    private function createDefaultAssets(){
	$asset = JTable::getInstance('Asset');

	if ($asset->loadByName('com_nge')){
		//Already exists
		return true;
	}
	$asset->name      = 'com_nge';
	$asset->parent_id = 1;
	$asset->rules     = '{"core.edit.patterns":{"3":1,"6":1},"core.edit.content":{"3":1,"6":1},"core.edit.options":{"3":1,"6":1},"core.edit.display":{"3":1,"6":1},"core.edit.access":{"5":1,"6":1}, "frontediting.edit":{"3":1,"6":1}, "patterns.manage":{"6":1}, "page.manage":{"6":1}}';
	$asset->title     = 'com_nge';
	$asset->setLocation(1, 'last-child');
	if (!$asset->store()){
		JFactory::getApplication()->enqueueMessage('Error while creating default assets.<br/>'.$sql, 'warning');
	}
	return true;
    }
    
}
