<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Ngestudio
 * @author     Bouillé <administration@teatis.com>
 * @copyright  Copyright (C) 2014. Tous droits réservés.
 * @license    GNU General Public License version 2 ou version ultérieure ; Voir LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Ngestudio records.
 *
 * @since  1.6
 */
class NgeModelPermissions extends JModelList
{
		
	public function getGroups()
	{
		$db = JFactory::getDbo();

		$query = 'SELECT a.*, COUNT(DISTINCT(b.`id`)) AS `level` FROM ' . $db->quoteName('#__usergroups') . ' AS a';
		$query .= ' LEFT JOIN ' . $db->quoteName('#__usergroups') . ' AS b';
		$query .= ' ON a.`lft` > b.`lft` AND a.`rgt` < b.`rgt`';
		$query .= ' GROUP BY a.`id`, a.`title`, a.`lft`, a.`rgt`, a.`parent_id`';
		$query .= ' ORDER BY a.`lft` ASC';

		$db->setQuery($query);
		$groups 	= $db->loadObjectList();

		return $groups;
	}
	
	/**
	 * A helper to get the list of user groups.
	 *
	 * @return	array
	 *
	 * @since	1.6
	 */
	public function getUserGroups()
	{
		// Get a database object.
		$db = JFactory::getDbo();

		// Get the user groups from the database.
		$query = $db->getQuery(true);
		$query->select('a.id AS value, a.title AS text, COUNT(DISTINCT b.id) AS level');
		$query->from('#__usergroups AS a');
		$query->join('LEFT', '#__usergroups AS b on a.lft > b.lft AND a.rgt < b.rgt');
		$query->group('a.id, a.title, a.lft');
		$query->order('a.lft ASC');
		$db->setQuery($query);
		$groups = $db->loadObjectList();

		return $groups;
	}
	
}
