<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Nge model.
 */
class NgeModelPart extends JModelAdmin {

    /**
     * @var		string	The prefix to use with controller messages.
     * @since	1.6
     */
    protected $text_prefix = 'COM_NGE';
    public $idpart = 0;
    public $part_category = '';

    public function render($name, $renderingmode = 'render', $urlparams = '', $storedsource='', $attribs='') {
	//Loading part params	
	$jinput = JFactory::getApplication()->input;
	
	//If $urlparams empty : reading from database
	//If not empty, params transmitted by the config screen.
	//No database reading. Only Memory.
	//Calling getPart constructor without part id => default part object created
	if ($storedsource == 'history'){
	    require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php';
	    $part = NgePartsHistoryHelper::getPart($name);
	}
	else
	if ($storedsource == 'pattern'){
	    if ($name != 0){
		require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
		$part = NgePatternDriver::load($name);
		//If content of pattern empty, load default content from part_library
		if ($part->content == ''){		    
		    $defaultPatternContent = NGEDATA::loadResult('SELECT content FROM #__nge_parts_library WHERE part = ' . NGEDATA::quote($part->name));
		    if ($defaultPatternContent != null)
			$part->content = $defaultPatternContent;
		}
	    }
	    else {
		$part = new stdClass;
		$part->id = 0;
		$part->title = '';
		$part->alias = '';
		$part->name = '';
		$part->library_title='';
		$part->library_description='';		
		$part->position = '';
		$part->content = '';
		$part->showtitle = 0;
		$part->control = '';
		$part->params = '';
		$part->published = '';
		$part->created_by = '';

	    }
	}
	else{
	    require_once NGEPATH_HELPERS . '/ngepartshelper.php';
	    $part = NgePartsHelper::getPart($name);
	}
	
	/*In config view this code is required to create only one ID when preview is launch*/
/*	$partId = json_decode($urlparams)->pk;
	if($part->id == 0 && $partId != "")
		$part->id = $partId;
*/
	$part->rendering = new stdClass();
	$part->rendering->mode = $renderingmode; //in preview mode, some stuff need to be desactivated (for example clic event on button preview)
	$part->rendering->libraries = $jinput->get('include_libraries', 1); //Include or not external javascript libraries (for example


	//The part parameters are replaced by the values passed in the url
	//content and params properties are mixed : no problem, they will be binded into the final params property
	//So we force content empty. When coming in urlparams from the config screen, content properties are already mixed
        $paramsArray = json_decode($part->params, true);
        if ($part->content != ''){
            $contentArray = json_decode($part->content, true);
            $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
            $part->params = $mergedParams;
        }
        
        if ($urlparams != ''){
            $urlparams_decode = json_decode($urlparams, true);
            $data_params_preset = NGE::array_load_preset($urlparams_decode);
            $part->content = '';
            if($part->params !== ''){
                if($data_params_preset !== false){
                     /*Get Array params with preset override by url params if exist*/
                    $part->params = json_encode(NGE::array_merge_recursive_replace($part->params, $data_params_preset));
                }else{
                     /*Get Array params with current url params*/
                    $part->params = json_encode(NGE::array_merge_recursive_replace($part->params, $urlparams_decode));
                }
            }else{
                if($data_params_preset !== false){
                     /*Get Array params with preset override by url params if exist*/
                    $part->params = json_encode($data_params_preset);
                }else{
                     /*Get Array params with current url params*/
                    $part->params = $urlparams;
                }
            }
	}
	//Renderering part
	require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
	//		$attribs = array('style' => 'view');
	ob_start();
	//Loading part content
	//$previewContent = NgePartHelper::render($part);
	$previewContent = NgePartRendererDefault::render($part, $attribs);

	//Applying content plugins, for recursive others parts included, and for other content plugins
	require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
	$params = new stdClass();
	$params->medium = 'config';
	$previewContent = NgeContenthelper::parse($previewContent, $params);
	echo $previewContent;
	$result = ob_get_clean();

	return $result;
    }

    public function generate($name, $urlparams = '') {
        $result = array();
	
        /*Get Part object well formatted*/
	require_once NGEPATH_HELPERS . '/ngepartshelper.php';
	$part = NgePartsHelper::getPart($name);
        $generate_options = json_decode($urlparams, true);

       /*If override form exist*/
        $paramsArray = json_decode($part->params, true);
        if(isset($generate_options["form"]) && $generate_options["form"] !== ""){
            $paramsArray = NGE::array_merge_recursive_replace($generate_options["form"], $paramsArray);
        }
        
        if ($part->content != ''){
            $contentArray = json_decode($part->content, true);
            $mergedParams = NGE::array_merge_recursive_replace($contentArray, $paramsArray);
            $part->params = $mergedParams;
        }
        
        $params = new JRegistry;
        $params->loadString(json_encode($part->params));
	$part->params = $params;
	
        $widget_name = preg_replace('/[^A-Z0-9_\.-]/i', '', $part->name);
	$widget_path = explode('.', $widget_name);
	$directories = '';
	for ($i = 0; $i < count($widget_path); $i++){
	    $directories .= $widget_path[$i] . '/';
        }

	$path = JPATH_SITE . '/components/com_nge/parts/' . $directories;
        
        if (file_exists($path . 'generate.php')){
            ob_start();
            include JPath::check($path . 'generate.php');
            $result = ob_get_clean();
        }else{
            $result = "<div class='alert' style='font-weight:bold;text-align:center;'>No generate files found!</div>";
        }

	return $result;
    }

		
    /**
     * Saving part
     *
     */
    public function save($data) {

	require_once NGEPATH_HELPERS . '/ngepartshelper.php';
	JPluginHelper::importPlugin('nge');	

	//On before save Event. If false, will not be saved
	NGE::triggerEvent( 'onPartBeforeSave', array( &$data) );

	if (isset($data['pk']))
	    $pk = $data['pk'];
	else
	    $pk = '';
	if (isset($data['plname']))
	    $plname = $data['plname'];
	else
	    $plname = '';
	if (isset($data['medium']))
	    $medium = $data['medium'];
	else
	    $medium = '';
	if (isset($data['medium_id']))
	    $medium_id = $data['medium_id'];
	else
	    $medium_id = '';
	if (isset($data['mode']))
	    $mode = $data['mode'];
	else
	    $mode = '';

	// decoding params values
	if (isset($data['ngecontent']))
	    parse_str($data['ngecontent'], $data_ngecontent);
	else
	    $data_ngecontent = '';
	if (isset($data['ngeparams']))
	    parse_str($data['ngeparams'], $data_ngeparams);
	else
	    $data_ngeparams = '';
	if (isset($data['ngedisplay']))
	    parse_str($data['ngedisplay'], $data_ngedisplay);
	else
	    $data_ngedisplay = '';
	if (isset($data['ngeinternal']))
	    parse_str($data['ngeinternal'], $data_ngeinternal);
	else
	    $data_ngeinternal = '';
	if (isset($data['ngeaccess']))
	    parse_str($data['ngeaccess'], $data_ngeaccess);
	else
	    $data_ngeaccess = '';

	if (isset($data_ngecontent['title'])){
	    $title = $data_ngecontent['title'];
	    unset($data_ngecontent['title']);
	}
	else
	    $title = '';
       
	if (isset($data_ngecontent['alias']))
	    $alias = NGE::stringURLSafe($data_ngecontent['alias']);
	else
	    $alias = NGE::stringURLSafe($title);

	//if (isset($data['access']['display']))	$access = 	$data['access']['display'];		else	$access = 1;
	if (isset($data['publish']['published']))
	    $published = $data['publish']['published'];
	else
	    $published = 1;
	
	$this->idpart = $pk;

	//data will be saved as params field
	//These are not params properties
	unset($data['title']);
	unset($data['params']);
	unset($data['option']);
	unset($data['task']);
	unset($data['Itemid']);
	unset($data['pk']);
	unset($data['plname']);
	unset($data['medium']);
	unset($data['medium_id']);
	
        /*If ngejson:: prefix exists, the following value is formated as litteral json string => decode it*/
	//Content
        if($data_ngecontent !== ""){/*Doesn't work if not an array like empty string*/
            $keyArrayJsonContent = NGE::recursive_array_search('ngejson::',$data_ngecontent);
            if($keyArrayJsonContent !== false){/*If value with json object string exists*/
                $data_ngecontent = NGE::decode_json_string($data_ngecontent, $keyArrayJsonContent);
            }
        }
        
	//Params
        if($data_ngeparams !== ""){/*Doesn't work if not an array like empty string*/
            $keyArrayJsonParams = NGE::recursive_array_search('ngejson::',$data_ngeparams);
            if($keyArrayJsonParams !== false){/*If value with json object string exists*/
                $data_ngeparams = NGE::decode_json_string($data_ngeparams, $keyArrayJsonParams);
            }
            
            /* Get preset params if exist and ovveride it with current params
            * If presets exist save all params of the preset pattern. */
            $data_params_preset = NGE::array_load_preset($data_ngeparams);
            if($data_params_preset !== false){
                $data_ngeparams = $data_params_preset;
            }
        }
        
	//If existing part, merging with existing params
	if ($pk != ''){
	    $part = NgePartsHelper::getPart('[' . $pk . ']');
	    if ($part->content != ''){
		$contentArray = json_decode($part->content, true);
		$mergedContent = NGE::array_merge_recursive_replace($contentArray, $data_ngecontent);
		$data_ngecontent = $mergedContent;
	
		//Since 2.1.0
		//Old content properties to be deleted (1.0.2).
		//When loaded in the configuration screen, old properties have been updated in new properties.
		//When we save here, properties are in the new format. We remove old properties if exist
		if (isset($data_ngecontent['sources']) || isset($data_ngecontent['link_types'])){
		    unset($data_ngecontent['sources']);
		    unset($data_ngecontent['htmls']);
		    unset($data_ngecontent['articles']);
		    unset($data_ngecontent['modules']);
		    unset($data_ngecontent['urls']);
		    unset($data_ngecontent['querys']);
		    unset($data_ngecontent['images']);
		    unset($data_ngecontent['content_sources']);
		    unset($data_ngecontent['content_images']);
		    unset($data_ngecontent['link_types']);
		    unset($data_ngecontent['link_menus']);
		    unset($data_ngecontent['link_articles']);
		    unset($data_ngecontent['link_images']);
		    unset($data_ngecontent['link_documents']);
		    unset($data_ngecontent['link_urls']);
		    unset($data_ngecontent['link_targets']);
		    unset($data_ngecontent['captions']);
		    unset($data_ngecontent['content_captions']);
		    unset($data_ngecontent['header_labels']);
		    unset($data_ngecontent['header_glyph_names']);
		    unset($data_ngecontent['content_titles']);
		    unset($data_ngecontent['content_headerglyphnames']);
		    unset($data_ngecontent['content_legends']);
		    unset($data_ngecontent['labels']);
		    unset($data_ngecontent['glyph_names']);
		    unset($data_ngecontent['content_legends']);
		}
		
	    }
	}

	$registry = new JRegistry;
	$registry->loadArray($data_ngecontent);
	$content = (string) $registry;


	// params field
	//options and display inputs of the config screen are saved in the params field
	//If existing part, merging with existing params
	if ($pk != ''){
	    if ($part->params != ''){
		$paramsArray = json_decode($part->params, true);
		$mergedParams = NGE::array_merge_recursive_replace($paramsArray, $data_ngeparams);
		$data_ngeparams = $mergedParams;
	    }
	}
	$registry = new JRegistry;
	$registry->loadArray($data_ngeparams);
	$registry->loadArray($data_ngedisplay);

	if(isset($data_ngeinternal['ngeversion'])){
		$registry->set('ngeversion', $data_ngeinternal['ngeversion']);
	}
	
	$params = (string) $registry;

	//Add user_id in table
	$user = JFactory::getUser();

	$save_result = false;

	//Existing part, updating params and resetting cache fields
	if (($pk != '') && ($mode != 'duplicate')) {
	    $sql = "UPDATE #__nge_parts SET title = '" . addslashes($title) . "', alias = '" . $alias . "', published = " . $published . ",content = '" . addslashes($content) . "', params = '" . addslashes($params) . "', html='', css='', js='', thumbnail='', modified=NOW(), modified_by='" . $user->id . "' WHERE id=" . (int) $pk;
	    $db = JFactory::getDBO();
	    $db->setQuery($sql);
	    $save_result = $db->execute();

	    //Creating history
	    if ($save_result){
		$this->savepart_history($pk);
				
		if(isset($data_ngeaccess['rules']))
    		  $this->savepart_asset($pk, $data_ngeaccess['rules']);
	    }

		// create or update part assets
		//Remove cache
		/*
		if ($part->cachable == true){
				$cache = JFactory::getCache('com_nge', '');
				$cacheId = 'part-'.$part->id.'-view'; 
				$cache->remove($part->content, $cacheId);
				$cacheId = 'part-'.$part->id.'-edit'; 
				$cache->remove($part->content, $cacheId);
		}*/
		
		
	} else
	if (($plname != '') || ($mode == 'duplicate') || ($mode == 'create')) {//Creating a new part
	    //Loading part library
	    $db = JFactory::getDBO();
	    $query = $db->getQuery(true);
	    if ($mode == 'duplicate') {
		$query->select(array('part'));
		$query->from('#__nge_parts');
		$query->where('id=' . (int) $pk);
	    } else {
		$query->select(array('part'));
		$query->from('#__nge_parts_library');
		$query->where('part=' . $db->quote($plname));
		$query->where('state=1');
	    }
	    $db->setQuery($query);
	    $result = $db->loadObject();
	    $partname = $result->part;


	    //Creating part
	    $query = $db->getQuery(true);
	    $columns = array('part', 'title', 'alias', 'content', 'params', 'language', 'published', 'created', 'created_by');
	    $values = array("'" . $partname . "', '" . addslashes($title) . "', '" . $alias . "', '" . addslashes($content) . "', '" . addslashes($params) . "', '*'", $published, 'NOW()', $user->id);
	    $query->insert($db->quoteName('#__nge_parts'))
		    ->columns($db->quoteName($columns))
		    ->values(implode(',', $values));
	    $db->setQuery($query);
	    $result = $db->execute();
	    $this->idpart = $db->insertid();

	    //Creating history
	    if ($result){	
	       $this->savepart_history($this->idpart);
				
    		// create or update part assets
    		if(isset($data_ngeaccess['rules']))
        		  $this->savepart_asset($this->idpart, $data_ngeaccess['rules']);
	    }

	    //If medium exists, the new part must be created in the medium 
	    //Searching the new part id
	    if ($medium != '') {
		$query = $db->getQuery(true);
		$query
			->select('id')
			->from('`#__nge_parts`')
			->order('ID Desc')
			->limit('0,1');
		$db->setQuery($query);
		$row = $db->loadObject();
		$this->idpart = $row->id;

		//Assigning the new part to the medium
		if (($medium == 'workshop') && ($medium_id != '')) {
		    $query = $db->getQuery(true);
		    $columns = array('id_parution', 'id_part', 'actif');
		    $values = array($medium_id, $this->idpart, 1);
		    $query
			    ->insert($db->quoteName('#__nge_parution_parts'))
			    ->columns($db->quoteName($columns))
			    ->values(implode(',', $values));

		    // Set the query using our newly populated query object and execute it.
		    $db->setQuery($query);
		    $result = $db->execute();
		}
	    }
	    $save_result = $result;
	    	    
	} else
	    $save_result = false;
		
	if($save_result) {
	    //On after save
	    NGE::triggerEvent( 'onPartAfterSave', array( $this->idpart, $data) );
	    
	    // complete property $part_category
	    $sql = "SELECT part FROM #__nge_parts WHERE id=" . (int) $this->idpart;
	    $db->setQuery($sql);
	    $this->part_category = $db->loadResult();
		
	}
	//print($$db->getQuery());
	//exit();
	// table assets pour les droits d'accès
//         if($save_result!=false) {
//             $asset = new JTableAsset($this->_db);
//             $asset->loadByName('com_nge.part.'.$pk);
//             $asset_parent = new JTableAsset($this->_db);
//             $asset_parent->loadByName('com_nge');
//             if(!$asset->id) {
//                 $asset->setLocation($asset_parent->id,'last-child');
//                 $asset->name = 'com_nge.part.'.$pk;
//                 $asset->parent_id = $asset_parent->id;
//                 $asset->title = $asset->name;
//                 $asset->level = 1;
//             }
//             $asset->rules = '{"core.edit.content":{"'.$data['access']['content'].'":1},"core.edit.option":{"'.$data['access']['options'].'":1}}';
//             if(!$asset->check())
//                 print('error');
//             $asset->store();
//         }
	
	
	return $save_result;
    }
    
    /**
     * restore part by it's history id
     *
     */
    public function restore($h_id) {
        require_once NGEPATH_HELPERS . '/ngepartshelper.php';
        require_once NGEPATH_HELPERS . '/ngepartshistoryhelper.php';

        /*Get history data*/
        $current_version_data = NgePartsHistoryHelper::getData($h_id);
        /*Restore current history data in part table.*/
        $result_update = self::updatePartWithHistory($current_version_data);

        $widget = NgePartsHelper::getPart("[".$current_version_data->part_id."]");
        
        return $widget;
    }

    /**
     * NgeModelpart::updatePartWithHistory()
     * upadte part info with old one, saved in history table of the database
     * @param object $old_part
     * @param $result true or false
     * @return
     */
    public function updatePartWithHistory($old_part) {
        $user = JFactory::getUser();
        $user_id = $user->id;
	$db = JFactory::getDBO();
	$sql = "update #__nge_parts SET title ='" . $old_part->title . "', alias ='" . $old_part->alias . "', part ='" . $old_part->name . "', content ='" .  addslashes($old_part->content) . "', params ='" .  addslashes($old_part->params) . "', modified=NOW(), modified_by=$user_id WHERE id=" . (int) $old_part->part_id;
	$db->setQuery($sql);
	$result = $db->execute();

	return $result;
    }
    
    /**
     * Method to remove one part 
     *
     * @return	boolean	Success
     */
    public function remove($idPart) {
	
	JPluginHelper::importPlugin('nge');
	NGE::triggerEvent( 'onPartBeforeDelete', array( $idPart ) );
	if (in_array(false, $result, true))
		return false;
	
	if ($idPart == null)
	    return false;

	//Read content to search parts and delete.

	$db = JFactory::getDbo();
	$query = $db->getQuery(true);

	$query->delete($db->quoteName('#__nge_parts'))
		->where('id=' . (int) $idPart);
	$db->setQuery($query);
	$result = $db->execute();

	if ($result)
	    NGE::triggerEvent( 'onPartAfterDelete', array( $idPart ) );
	return $result;
    }

    /**
     * Abstract method for getting the form from the model.
     *
     * @param   array    $data      Data for the form.
     * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
     *
     * @return  mixed  A JForm object on success, false on failure
     *
     * @since   12.2
     */
    public function getForm($data = array(), $loadData = true) {
	
    }

    /**
     * NgeModelpart::load_part_content()
     * Load params field
     * @param mixed $part_id
     * @return
     */
    public function load_part_content($part_id) {
	$db = JFactory::getDBO();
	$sql = "SELECT content FROM #__nge_parts WHERE id=" . (int) $part_id;
	$db->setQuery($sql);

	$result = $db->loadResult();

	return $result;
    }

    /**
     * NgeModelpart::load_part_params()
     * Load params field 
     * @param mixed $part_id
     * @return
     */
    public function load_part_params($part_id) {
	$db = JFactory::getDBO();
	$sql = "SELECT params FROM #__nge_parts WHERE id=" . (int) $part_id;
	$db->setQuery($sql);

	$result = $db->loadResult();

	return $result;
    }

    /**
     * NgeModelpart::savepart_content()
     * save params field
     * @param mixed $part_id
     * @param mixed $params
     * @return
     */
    public function savepart_content($part_id, $content) {
        $user = JFactory::getUser();
        $user_id = $user->id;
	$db = JFactory::getDBO();
	$sql = "update  #__nge_parts SET content ='" . addslashes($content) . "', modified=NOW(), modified_by=$user_id WHERE id=" . (int) $part_id;
	$db->setQuery($sql);
	$result = $db->execute();

	return $result;
    }

    /**
     * 
     * @param integer $partId : id of the part where to modify property
     * @param string $propertyType : type of param : "content" or "params"
     * @param string $propertyPath : path of the property. use "." between object properties
     * @param string $value : value of the property
     * @return boolean
     */
    public function getProperty($partId, $propertyType, $propertyPath) {

	//Property key contains the property path separated by - Example : content.header.label
	$keys = explode('.', $propertyPath);

	// If no key, error and stopping script
	if (count($keys) == 0) {
	    print('error - No property key defined');
	    exit();
	}
	
	// loading corresponding params
	$db = JFactory::getDBO();
	if ($propertyType == 'content') {
	    $sql = "SELECT content FROM #__nge_parts WHERE id=" . (int) $partId;

	    $db->setQuery($sql);
	    $currentContent = $db->loadResult();

	    if (!$currentContent) {
		print('error - No content found');
		exit();
	    }

	    $content = json_decode($currentContent, true);

	    //$content is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $content;

	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }
	    $result = $propertyPointer;
	} else
	if ($propertyType == 'params') {
	    $sql = "SELECT params FROM #__nge_parts WHERE id=" . (int) $partId;
	    $db->setQuery($sql);
	    $currentParams = $db->loadResult();

	    if (!$currentParams) {
		print('error - No params found');
		exit();
	    }

	    $params = json_decode($currentParams, true);
	    //$content is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $params;
	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }
	    $result = $propertyPointer;
	} else
	    return false;

	return $result;
    }

    /**
     * 
     * @param integer $partId : id of the part where to modify property
     * @param string $propertyType : type of param : "content" or "params"
     * @param string $propertyPath : path of the property. use "." between object properties
     * @param string $value : value of the property
     * @return boolean
     */
    public function storeProperty($partId, $propertyType, $propertyPath, $value) {
        $user = JFactory::getUser();
        $user_id = $user->id;
	$db = JFactory::getDBO();

	//Property key contains the property path separated by - Example : content.header.label
	$keys = explode('.', $propertyPath);

	// If no key, error and stopping script
	if (count($keys) == 0) {
	    print('error - No property key defined');
	    exit();
	}

	// loading corresponding params
	if ($propertyType == 'content') {
	    $sql = "SELECT content FROM #__nge_parts WHERE id=" . (int) $partId;
	    $db->setQuery($sql);
	    $currentContent = $db->loadResult();

	    if (!$currentContent) {
		print('error - No content found');
		exit();
	    }

	    $content = json_decode($currentContent, true);
	    //$content is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $content;

	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }

	    $propertyPointer = $value;
	    $newContent = json_encode($content);

	    //saving
	    $sql = "update  #__nge_parts SET content ='" . addslashes($newContent) . "', modified=NOW(), modified_by=$user_id WHERE id=" . (int) $partId;
	    $db->setQuery($sql);
	    $result = $db->execute();
	} else
	if ($propertyType == 'params') {
	    $sql = "SELECT params FROM #__nge_parts WHERE id=" . (int) $partId;
	    $db->setQuery($sql);
	    $currentParams = $db->loadResult();

	    if (!$currentParams) {
		print('error - No params found');
		exit();
	    }

	    $params = json_decode($currentParams, true);
	    //$content is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $params;
	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }
	    $propertyPointer = $value;
	    $newParams = json_encode($params);

	    //saving
	    $sql = "update  #__nge_parts SET params ='" . addslashes($newParams) . "', modified=NOW(), modified_by=$user_id WHERE id=" . (int) $partId;
	    $db->setQuery($sql);
	    $result = $db->execute();
	} else
	    return false;

	return $result;
    }
    
    
    
    /**
     * NgeModelpart::savepart_params()
     * save params field
     * @param mixed $part_id
     * @param mixed $params
     * @return
     */
    public function savepart_params($part_id, $params) {
        $user = JFactory::getUser();
        $user_id = $user->id;

	$db = JFactory::getDBO();
	$sql = "update  #__nge_parts SET params ='" . addslashes($params) . "', modified=NOW(), modified_by=$user_id WHERE id=" . (int) $part_id;
	$db->setQuery($sql);

	$result = $db->execute();

	return $result;
    }

    /**
     * NgeModelPart::savepart_history()
     * copy part in #__nge_parts_history
     * @param int $pk part id
     * @return void
     */
    public function savepart_history($pk) {
        $db = JFactory::getDbo();
        $query = 'INSERT INTO #__nge_parts_history (part_id, part, title, alias, content, params, language, created, created_by, modified, modified_by) '
			. 'SELECT id, part, title, alias, content, params, language, created, created_by, modified, modified_by FROM #__nge_parts WHERE id=' . (int) $pk;
		$db->setQuery($query);
		$db->execute();
        // delete history over 20 records
        $query = 'SELECT id FROM #__nge_parts_history WHERE part_id='. (int) $pk .' order by id desc limit 20,1 ';
		$db->setQuery($query);
		$id = $db->loadResult();
		
		if($id) {
			$query = 'delete FROM #__nge_parts_history WHERE part_id='. (int) $pk .' and id<=' . (int) $id;
			$db->setQuery($query);
			$db->execute();
		}
        
        return true;        
    }
    

    /**
     * NgeModelPart::savepart_asset()
     * 
     * @param int $pk part id
     * @param array $rules rules array from jinputs
     * @return bool
     */
    public function savepart_asset($pk, $rules = array() ) {
	    
	// create asset nam
	$assetName = 'com_nge.part.'.$pk;
        
	// load a JTable Asset with the assetname
	$partsAssets = $this->getTable('asset', 'JTable');
	$partsAssets->loadByName($assetName);
        
	// parse rules and format a new array with only values 0 or 1
	$assetsArray = array();
	foreach($rules as $ruleKey=>$ruleValues) { // rulekey = core.edit, ruleValues = array('1'=>0, '2'=>, '3'=>0, ...))
	    foreach ($ruleValues as $groupKey=>$groupAccess) { // groupKey=Joomla group Id (public register...), groupAcces= null, 0 or 1
		    if($groupAccess!=null)
			    $assetsArray[$ruleKey][$groupKey] = (int)$groupAccess;
		// ex       ['core.create']['1']  = 0
	    }
	}
		
	// if asset not exist
	if( !$partsAssets->id ) {
	       
	    $partsAssets->name = $assetName;
	    $partsAssets->title = 'com_nge part';

	    //get parent asset id ( parentname = com_nge)
	    $parentAsset = $this->getTable('asset', 'JTable');
	    $parentAsset->loadByName('com_nge');

	    if( $parentAsset->id ) {
		$partsAssets->setLocation($parentAsset->id, 'last-child');
		$partsAssets->parent_id = $parentAsset->id;
	    }
	}
	    
	//$assetsTbl->bind();
	if (count($assetsArray)==0)
	    $partsAssets->save(array('rules'=>''));
	else
	    $partsAssets->save(array('rules'=>json_encode($assetsArray)));
    }
    
    /**
     * NgeModelpart::getFieldContent()
     * @return new field content
     */
    public function getFieldContent($nameForm, $pathForm, $nameField, $newValue) {
	require_once NGEPATH_HELPERS . '/ngeparthelper.php'; //Used in each config file to load the part form

	$field_content = "";

	$jform = NgePartHelper::loadFormAjax($nameForm, $pathForm, $nameField, $newValue);

	$field_content = $jform->getInput((string) $nameField);

	return $field_content;
    }

    /**
     * NgeModelpart::getPart()
     * 
     * @param mixed $pk
     * @return
     */
    public function getPart($pk) {
	$db = JFactory::getDBO();

	$db->setQuery('SELECT * FROM #__nge_parts WHERE id=' . (int) $pk);

	return $db->loadObject();
    }

}
