<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

require_once(__DIR__.'/../classes/installer.php');
require_once(__DIR__.'/../classes/xml.php');

jimport('joomla.installer.helper');
jimport('joomla.filesystem.folder');

class NgeModelInstall extends JModelLegacy
{
    /** @var object JTable object */
    var $_table = null;

    /** @var object JTable object */
    var $_url = null;
    var $_result = array();

    public function cancel() {
        $this->setRedirect(JRoute::_('index.php?option=com_jce&client=' . $client, false));
    }

    public function install($package = null) {
        $app = JFactory::getApplication();

        if (!$package) {
            $package = $this->getPackage();
        }

        // Was the package unpacked?
        if (!$package) {
            $this->setState('message', 'NGE_INSTALLER_NO_PACKAGE');
            return false;
        }

        // Get an installer instance
        $installer = NgeInstaller::getInstance();

        // Install the package
        if (!$installer->install($package['dir'])) {
            $result = false;

            $app->enqueueMessage(JText::sprintf('NGE_INSTALLER_INSTALL_ERROR'), 'error');
        } else {
            $result = true;

            $app->enqueueMessage(JText::sprintf('NGE_INSTALLER_INSTALL_SUCCESS'));
        }

        $this->_result[] = array(
            'name' => $installer->get('name'),
            'type' => $package['type'],
            'version' => $installer->get('version'),
            'result' => $result
        );

        $this->setState('install.result', $this->_result);

        $this->setState('name', JText::_($installer->get('name')));
        $this->setState('message', JText::_($installer->get('message')));
        $this->setState('extension.message', $installer->get('extension.message'));
        $this->setState('result', $result);		
		
        // Cleanup the install files
        if (!is_file($package['packagefile'])) {
            $package['packagefile'] = $app->getCfg('tmp_path') . '/' . $package['packagefile'];
        }
        if (is_file($package['packagefile'])) {
            JInstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
        }
        return $result;
    }

    public function uninstall($id) {
        $app = JFactory::getApplication();
        $db = JFactory::getDbo();
        
        // search for record in database
        $sql = "SELECT * FROM #__nge_plugins WHERE name='$id'";
        $db->setQuery($sql);
        $rec_plugin = $db->loadObject();
        
        if(!$rec_plugin) {
			return false;
		}


        $installer = NgeInstaller::getInstance();
		$type = "nge_".$rec_plugin->type;
        $installer->setAdapter($type);
        $result = $installer->uninstall($type, $rec_plugin->name);


        if (!$result) {
            $app->enqueueMessage(JText::sprintf('NGE_INSTALLER_UNINSTALL_ERROR'), 'error');
        } else {
            $app->enqueueMessage(JText::sprintf('NGE_INSTALLER_UNINSTALL_SUCCESS'));
        }

        $this->_result[] = array(
            'name' => $installer->get('name'),
            'type' => $type,
            'version' => $installer->get('version'),
            'result' => $result
        );

        $this->setState('name', JText::_($installer->get('name')));
        $this->setState('result', $result);
        $this->setState('install.result', $this->_result);

        return $result;
    }

    /**
     * Get the install package or folder
     * @return Array $package
     */
    private function getPackage() {
        $app = JFactory::getApplication();
        jimport('joomla.filesystem.file');
        jimport('joomla.filesystem.archive');
		$jinput = JFactory::getApplication()->input;
		
		if($jinput->get('installtype','','raw')=='upload') {
				// set standard method
	        $upload = true;
	        $package = null;

	        // Get the uploaded file information
	        $file = $jinput->files->get('install_package', null, 'raw');
	        // get the file path information
	        $path = $jinput->get('install_input','','raw');

	        if (!(bool) ini_get('file_uploads') || !is_array($file)) {
	            $upload = false;
	            // no path either!
	            if (!$path) {
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_NO_FILE'), 'warning');
	                return false;
	            }
	        }

	        // Install failed
	        if (!is_uploaded_file($file['tmp_name']) || !$file['tmp_name'] || !$file['name'] || $file['error']) {
	            $upload = false;
	            // no path either!
	            if (!$path) {
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_NO_FILE'), 'warning');			
	                return false;
	            }
	        }

	        // uploaded file
	        if ($upload) {
	            // check extension
	            if (!preg_match('/\.(zip|tar|gz|gzip|tgz|tbz2|bz2|bzip2)$/i', $file['name'])) {
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_INVALID_FILE'), 'warning');
	                return false;
	            }

	            $dest   = JPath::clean($app->getCfg('tmp_path') . '/' . $file['name']);
	            $src    = $file['tmp_name'];
	            // upload file
	            if (!JFile::upload($src, $dest,false,true)) {
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_UPLOAD_FAILED'), 'warning');
	                return false;
	            }
	            
	            if (!is_file($dest)) {
		JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_UPLOAD_FAILED'), 'warning');
	                return false;
	            }
	            
	            // path to file
	        } else {
	            $dest = JPath::clean($path);
	        }
	    }
	    
	    if($jinput->get('installtype')=='folder') {
	        $path = $jinput->get('install_directory','', 'raw');
			$dest = JPath::clean($path);
			 
		}

        // set install method
        $jinput->get('install_method', 'install', 'raw');

        // Unpack the package file
        if (preg_match('/\.(zip|tar|gz|gzip|tgz|tbz2|bz2|bzip2)/i', $dest)) {
            // Make sure that zlib is loaded so that the package can be unpacked
            if (!extension_loaded('zlib')) {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_WARNINSTALLZLIB'), 'warning');
                return false;
            }

            $package = JPath::clean(dirname($dest) . '/' . uniqid('install_'));

            if (!JArchive::extract($dest, $package)) {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_EXTRACT_ERROR'), 'warning');
                return false;
            }

            if (JFolder::exists($package)) {
                $type = self::detectType($package);
            }

            return array(
                'manifest' => null,
                'packagefile' => $dest,
                'extractdir' => $package,
                'dir' => $package,
                'type' => $type
            );

            // might be a directory
        } else {
            if (!is_dir($dest)) {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_INVALID_SRC'), 'warning');
                return false;
            }

            // Detect the package type
            $type = self::detectType($dest);

            return array(
                'manifest' => null,
                'packagefile' => null,
                'extractdir' => null,
                'dir' => $dest,
                'type' => $type
            );
        }
    }

    private static function detectType($path) {
        // Search the install dir for an XML file
        $files = JFolder::files($path, '\.xml$', 1, true);

        if (!count($files)) {
            return false;
        }

        foreach ($files as $file) {
            $xml = simplexml_load_file($file);
            if (!$xml) {
                continue;
            }

            $name = (string) $xml->getName();

            if ($name != 'extension' && $name != 'install') {
                unset($xml);
                continue;
            }

            $type = (string) $xml->attributes()->type;

            // Free up memory
            unset($xml);
            return $type;
        }
        return false;
    }

    public function getExtensions() {
        wfimport('admin.models.plugins');
        $model = new WFModelPlugins();

        // get an array of all installed plugins in plugins folder
        $extensions = $model->getExtensions();

        return $extensions;
    }

    public function getPlugins() {
        wfimport('admin.models.plugins');
        $model = new WFModelPlugins();

        // get an array of all installed plugins in plugins folder
        $plugins = $model->getPlugins();

        $rows = array();

        $language = JFactory::getLanguage();

        foreach ($plugins as $plugin) {
            if ($plugin->core == 0) {
                $rows[] = $plugin;
                $language->load('com_jce_' . trim($plugin->name), JPATH_SITE);
            }
        }

        return $rows;
    }

    /**
     * Get additional plugins such as JCE MediaBox etc.
     * @return 
     */
    public function getRelated() {
        // Get a database connector
        $db = JFactory::getDBO();

        $params = JComponentHelper::getParams('com_jce');

        // pre-defined array of other plugins
        $related = preg_replace('#(\w+)#', "'$1'", $params->get('related_extensions', 'jcemediabox,jceutilities,mediaobject,wfmediabox'));
        $query  = $db->getQuery(true);

        // Joomla! 2.5
        if (is_object($query)) {
            $query->select(array('extension_id', 'name', 'element', 'folder'))->from('#__extensions')->where(array('type = ' . $db->Quote('plugin'), 'element IN (' . $related . ')'))->order('name');
            // Joomla! 1.5    
        } else {
            $query = 'SELECT id, name, element, folder FROM #__plugins WHERE element IN (' . $related . ') ORDER BY name';
        }

        $db->setQuery($query);
        $rows = $db->loadObjectList();

        $language = JFactory::getLanguage();

        $num = count($rows);
        
        for ($i = 0; $i < $num; $i++) {
            $row = $rows[$i];

            if (defined('JPATH_PLATFORM')) {
                $file = JPATH_PLUGINS . '/' . $row->folder . '/' . $row->element . '/' . $row->element . ".xml";
            } else {
                $file = JPATH_PLUGINS . '/' . $row->folder . '/' . $row->element . ".xml";
            }
            
            if (isset($row->extension_id)) {
                $row->id = $row->extension_id; 
            }

            if (is_file($file)) {
                $xml = WFXMLElement::load($file);

                if ($xml) {
                    $row->title = (string) $xml->name;

                    $row->author = (string) $xml->author;
                    $row->version = (string) $xml->version;
                    $row->creationdate = (string) $xml->creationDate;
                    $row->description = (string) $xml->description;
                    $row->authorUrl = (string) $xml->authorUrl;
                }
            }

            $language->load('plg_' . trim($row->folder) . '_' . trim($row->element), JPATH_ADMINISTRATOR);
            $language->load('plg_' . trim($row->folder) . '_' . trim($row->element), JPATH_SITE);
        }

        //return array_values($rows);
        return $rows;
    }

    public function getLanguages() {
        // Get the site languages
        $base = JLanguage::getLanguagePath(JPATH_SITE);
        $dirs = JFolder::folders($base);

        for ($i = 0; $i < count($dirs); $i++) {
            $lang = new stdClass();
            $lang->folder = $dirs[$i];
            $lang->baseDir = $base;
            $languages[] = $lang;
        }
        $rows = array();
        foreach ($languages as $language) {
            $files = JFolder::files($language->baseDir . '/' . $language->folder, '\.(com_jce)\.xml$');
            foreach ($files as $file) {
                $data = WFXMLHelper::parseInstallManifest($language->baseDir . '/' . $language->folder . '/' . $file);

                $row = new StdClass();
                $row->language = $language->folder;

                if ($row->language == 'en-GB') {
                    $row->cbd = 'disabled="disabled"';
                    $row->style = ' style="color:#999999;"';
                } else {
                    $row->cbd = '';
                    $row->style = '';
                }

                // If we didn't get valid data from the xml file, move on...
                if (!is_array($data)) {
                    continue;
                }

                // Populate the row from the xml meta file
                foreach ($data as $key => $value) {
                    $row->$key = $value;
                }
                $rows[] = $row;
            }
        }

        return $rows;
    }

}