<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

class JFormFieldNgelist extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  11.1
	 */
	protected $type = 'Ngelist';

	/**
	 * Method to get the field input markup for a generic list.
	 * Use the multiple attribute to enable multiselect.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput()
	{
		$html = array();
		$list_id = 'jep-list-'.$this->name;	
		$attr_select = '';
		$array_attrib = array();
		$script = array();
		
		// Initialize some field attributes for select tag.
		$attr_select .= !empty($this->class) ? ' class="' . $this->class . '"' : '';
		$attr_select .= !empty($this->size) ? ' size="' . $this->size . '"' : '';
		$attr_select .= $this->multiple ? ' multiple' : '';
		$attr_select .= $this->required ? ' required aria-required="true"' : '';
		$attr_select .= $this->autofocus ? ' autofocus' : '';

		// To avoid user's confusion, readonly="true" should imply disabled="true".
		if ((string) $this->readonly == '1' || (string) $this->readonly == 'true' || (string) $this->disabled == '1'|| (string) $this->disabled == 'true')
		{
			$attr_select .= ' disabled="disabled"';
		}

		// Initialize JavaScript field attributes.
		$attr_select .= $this->onchange ? ' onchange="' . $this->onchange . '"' : '';
		
		$array_attrib = array();
		$array_attrib['id'] = $list_id;
		$array_attrib['list.attr'] = trim($attr_select);
		//$array_attrib['list.translate'] = $translate;
		$array_attrib['option.key'] = 'value';
		$array_attrib['option.text'] = 'text';
		//Need to add this line to add option attribute
		$array_attrib['option.attr'] = 'attr';
		$array_attrib['list.select'] = $this->value;
		// Get the field options.
		$options = (array) $this->getOptions();
		// Create a read-only list (no name) with a hidden input to store the value.
		if ((string) $this->readonly == '1' || (string) $this->readonly == 'true')
		{
			$html[] = JHtml::_('select.genericlist', $options, '', $array_attrib);
			$html[] = '<input type="hidden" name="' . $this->name . '" value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"/>';
		}
		else
		// Create a regular list.
		{
			$html[] = JHtml::_('select.genericlist', $options, $this->name, $array_attrib);
		}
		
		//TODO updateDatatargets to be merged with the getButtonsDatatargetScript function in the JFormFieldJep class, like JformFieldJepradio
		
		//Add some script
		$script[] = "
		function fieldGroupNode(childObj, fieldType) {
			var testObj = childObj;
			var count = 1;
				
			if(fieldType != 'input'){
				testObj = childObj.parent();
				while((!testObj.hasClass('control-group')) && (count<10)) {
					testObj = testObj.parent();
					count++;
				}
			}
				
			if (count!= 10)
				return testObj;
			else
				return null;
		}
		
		function fieldsGroupsNode(arrayChildObj) {
			var objectReturn = [];
			var count = 1;
				
			arrayChildObj.each(function(res){
				if(isNaN(res) == false){
					objectReturn.push(fieldGroupNode(jQuery(this)));
				}
			});
							
			return objectReturn;
		}
				
		function getAllTarget(group){
			var arrayAll = [];	
						
			group.children().each( function(){
				var test1 = jQuery(this);
				var test = jQuery(this).attr('data-target');
				if(typeof (jQuery(this).attr('data-target')) != 'undefined'){
					arrayAll.push(jQuery(this).attr('data-target'));
				}
			});
			
			if(arrayAll.length !=0)
			{
				return arrayAll;
			}else{
				return false;
			}	
		}
				
		function getCurrentTarget(group){
			var arrayCurrent = [];
			var arraySelected = [];	
			if (typeof(group.val()) == 'string'){
				arraySelected = [group.val().split(' ')];
			}else{
				arraySelected = group.val();
			}
			if (arraySelected == undefined){
			    return false;
			}
			    
			for(var i=0, selectedLength=arraySelected.length; i<selectedLength; i++){
				var currentVal = group.children('option[value='+arraySelected[i]+']').attr('data-target');
				if(typeof(currentVal) != 'undefined'){
					arrayCurrent.push(currentVal);
				}
			}
			
			if(arrayCurrent.length !=0)
			{
				return arrayCurrent;
			}else{
				return false;
			}	
		}

		function updateDatatargets(group){
				var arrayCurrentTarget = [];
				var arrayAllTarget = [];	
				var parentGroupNode = fieldGroupNode(group);	
				
				arrayCurrentTarget = getCurrentTarget(group);
				arrayAllTarget	= getAllTarget(group);
						
				/*Hide all target element*/
				if(arrayAllTarget !== false){
					for(var i=0, targetLength=arrayAllTarget.length; i<targetLength; i++){
						var datatargets = arrayAllTarget[i].toString();
						var targets = datatargets.split(' ');
						
						targets.forEach(function(target) {
							if (target.substr(0,6) == 'field:'){								
								divtarget = fieldGroupNode(jQuery(\"[name*='\"+target.substring(6)+\"']\", parentGroupNode.parent()), 'field');  
								if (divtarget != null)
									divtarget.hide();										
							}else if(target.substr(0,7) == 'fields:'){
								divGroup = fieldsGroupsNode(jQuery(\"[name*='\"+target.substring(7)+\"']\", parentGroupNode.parent()), 'fields');
								divGroup.each(function(divtarget) {  
								if (divtarget != null)
									divtarget.hide();
								});	
							}else if(target.substr(0,6) == 'input:'){
								var currentField = jQuery(\"[name*='\"+target.substring(6)+\"']\", parentGroupNode.parent());
								var currentFieldAttr = currentField.attr('class');
								if(currentFieldAttr == 'mce_editable'){ 
									currentField = currentField.parent();
								}
								divtarget = fieldGroupNode(currentField, 'input');
								if (divtarget != null)
									divtarget.hide(); 	
							}else{
								jQuery(target).hide();
							}
						});
					}
				}
				
				/*Display current target*/
				if(arrayCurrentTarget != false){
					for(var i=0, currentTargetLength=arrayCurrentTarget.length; i<currentTargetLength; i++){
						var datatargets = arrayCurrentTarget[i].toString();
						var targets = datatargets.split(' ');
						
						targets.forEach(function(target) {
							if (target.substr(0,6) == 'field:'){
								divtarget = fieldGroupNode(jQuery(\"[name*='\"+target.substring(6)+\"']\", parentGroupNode.parent()), 'field'); 
								if (divtarget != null)
									divtarget.show();																
							}else if(target.substr(0,7) == 'fields:'){
								divGroup = fieldsGroupsNode(jQuery(\"[name*='\"+target.substring(7)+\"']\", parentGroupNode.parent()), 'fields');
								divGroup.each(function(divtarget) {  
								if (divtarget != null)
									divtarget.show();
								});	
							}else if(target.substr(0,6) == 'input:'){
								var currentField = jQuery(\"[name*='\"+target.substring(6)+\"']\", parentGroupNode.parent());
								var currentFieldAttr = currentField.attr('class');
								if(currentFieldAttr == 'mce_editable'){ 
									currentField = currentField.parent();
								}
								divtarget = fieldGroupNode(currentField, 'input');
								if (divtarget != null)
									divtarget.show(); 
							}else{
								jQuery(target).show();
							}
						});
					}
				}
		}
		";
		
		$script[] = "
			jQuery(function() {
				var group = jQuery('#". $list_id . "');
				updateDatatargets(group);
				group.change( function() {
					updateDatatargets(group);	
				});
			});
		";

		return implode($html) . '<script>'.implode($script).'</script>';		
	}

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   11.1
	 */
	protected function getOptions()
	{
		$options = array();

		foreach ($this->element->children() as $option)
		{
			// Only add <option /> elements.
			if ($option->getName() != 'option')
			{
				continue;
			}

			// Filter requirements
			if ($requires = explode(',', (string) $option['requires']))
			{
				// Requires multilanguage
				if (in_array('multilanguage', $requires) && !JLanguageMultilang::isEnabled())
				{
					continue;
				}

				// Requires associations
				if (in_array('associations', $requires) && !JLanguageAssociations::isEnabled())
				{
					continue;
				}
			}

			$value = (string) $option['value'];
			$datatarget = isset($option['data-target']) && $option['data-target'] != '' ? ' data-target="'.$option['data-target'].'"':'';
			$disabled = (string) $option['disabled'];
			$disabled = ($disabled == 'true' || $disabled == 'disabled' || $disabled == '1');

			$disabled = $disabled || ($this->readonly && $value != $this->value);

			// Create a new option object based on the <option /> element.
			$tmp = JHtml::_(
				'select.option', $value,
				JText::alt(trim((string) $option), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)), 'value', 'text',
				$disabled
			);
			
			// Set some option attributes.
			$tmp->class = (string) $option['class'];
			$tmp->attr = (string) $datatarget;
			
			// Set some JavaScript option attributes.
			$tmp->onclick = (string) $option['onclick'];
			// Add the option object to the result set.
			$options[] = $tmp;
		}

		reset($options);

		return $options;
	}
}
