<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
class NgeModelCpanel extends JModelLegacy
{
	public function getPluginsParams(){
		$result = array();

		$listPluginsRequire = array(
				'nge_content' => 'content',
				'tinymce' => 'editors',
				'jce' => 'editors',
				'jckeditor' => 'editors',
				'arkeditor' => 'editors'
		);
	
		foreach ($listPluginsRequire as $key => $value) {
			$result[$key] = new stdClass();
				
			$pluginParams = $this->getPluginNge($key, $value);
			$pluginEnabled = $this->isPluginNgeEnabled($pluginParams);
			$pluginInstalled = $this->isInstallPlugin($key, $value);
			$pluginNgeMissing = $this->isMissingNgePlugin($key, $value);
			$pluginNgeEnabled = $this->isEnabledNgePlugin($key, $value, $pluginParams);

			if(isset($pluginParams) && $pluginParams != null){
				$result[$key] = $pluginParams;
				$result[$key]->params = json_decode($pluginParams->params);
			}else{
				$result[$key]->type = $value;
				$result[$key]->name = $key;
			}
			if(isset($pluginEnabled)){
				$result[$key]->isEnabled = $pluginEnabled;
			}
			if(isset($pluginInstalled)){
				$result[$key]->isInstalled = $pluginInstalled;
			}
			$result[$key]->isNgeMissing = $pluginNgeMissing;
			$result[$key]->isNgeEnabled = $pluginNgeEnabled;
		}
		
		return $result;
	}
	
    /**
     * Activate a joomla plugin (change "enabled" to 1)
     * @var $plg_name, $plg_type 
     * @return $array_msg (return message and the type of message "error", "success" ...)
     */
    public function enableJoomlaPlugin($plg_name, $plg_type = "") {
    	$array_msg = array();
        // Get a database connector
        $db = JFactory::getDBO();
		
        $query = $db->getQuery(true);
        
        // Fields to update.
        $fields = array($db->quoteName('enabled') . ' = 1');
        
        // Conditions for which records should be updated.
        $conditions = array(
        		$db->quoteName('element') . ' = "'. $plg_name .'"',
        		$db->quoteName('folder') . ' = "' . $plg_type .'"'
        );
        $query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
        
        $db->setQuery($query);
        
        $result = $db->execute();
        
        if(isset($result) && $result == true){
        	$array_msg["msg"] = JText::_( 'COM_NGE_I_P_MESSAGE_SUCCESS_'.strtoupper($plg_name) );
        	$array_msg["msg_type"] = null;
        }else{
        	$array_msg["msg"] = JText::_( 'COM_NGE_I_P_MESSAGE_ERROR_'.strtoupper($plg_name) );
        	$array_msg["msg_type"] = "error";
        }
        
        return $array_msg;
    }
    
    /**
     * Activate a Nge plugin for editor
     * @var $plg_name, $plg_type
     * @return $array_msg (return message and the type of message "error", "success" ...)
     */
    public function enableNgePlugin($plg_name, $plg_type = "") {        
    	$array_msg = array();
    	// Get a database connector
    	$db = JFactory::getDBO();
    
    	$query = $db->getQuery(true);
    
    	// Fields to update.
    	if($plg_name == "tinymce"){
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.tinymce.php');
		$result = ngeHelperTinymceInstaller::installAddon(true);
    	}else if($plg_name == "jce"){
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php');
		$result = ngeHelperJceInstaller::installAddon(true);
    	}else if($plg_name == "jckeditor"){
		require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php');
		$result = ngeHelperArkInstaller::installAddon(true);
    	}else if($plg_name == "jckeditor"){
    		$fields = array($db->quoteName('enabled') . ' = 1');
    		
    		$conditions = array(
    				$db->quoteName('folder') . ' = "arkeditor"',
    				$db->quoteName('element') . ' = "nextgeneditor"',
    		);
    		$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
        	$db->setQuery($query);
        
        	$result = $db->execute();
        
    	}
    
    	if(isset($result) && $result == true){
    		$array_msg["msg"] = JText::_( 'COM_NGE_I_P_MESSAGE_SUCCESS_PLG_'.strtoupper($plg_name) );
    		$array_msg["msg_type"] = null;
    	}else{
    		$array_msg["msg"] = JText::_( 'COM_NGE_I_P_MESSAGE_ERROR_PLG_'.strtoupper($plg_name) );
    		$array_msg["msg_type"] = "error";
    	}
    
    	return $array_msg;
    }
    
    public function isJckPluginEnabled() {
    	$isEnabled = false;
    	
    	$db = JFactory::getDbo();
		$db->setQuery("SELECT published FROM #__jckplugins WHERE name = 'nge'");
		$res = $db->loadResult();

		if($res == "0"){
			$isEnabled = false;
		}else{
			$isEnabled = true;
		}
		
		return $isEnabled;
    }
    
   public function isArkPluginEnabled() {
    	$isEnabled = false;
    	
    	$db = JFactory::getDbo();
		$db->setQuery("SELECT enabled FROM #__extensions WHERE folder='arkeditor' AND element = 'nextgeneditor'");
		$res = $db->loadResult();

		if(!$res || $res == "0"){
			$isEnabled = false;
		}else{
			$isEnabled = true;
		}
		
		return $isEnabled;
    }

    protected function isInstallPlugin($key, $value = ""){
    	$isInstall = false;
    
    	$db = JFactory::getDbo();
    	$db->setQuery("SELECT name FROM #__extensions WHERE element = '$key' AND folder ='$value'");
    	$isInstall = $db->loadResult();
    
    	if(is_null($isInstall)){
    		$isInstall = false;
    	}else{
    		$isInstall = true;
    	}
    
    	return $isInstall;
    }
    
    protected function isMissingNgePlugin($key, $value = ""){
    	$isMissing = false;
    
    	switch ($key) {
    		case "tinymce":
    			if ( !file_exists(JPATH_ROOT . "/media/editors/tinymce/plugins/nge/plugin.min.js") ){
    				$isMissing = true;
    			}else{
    				$isMissing = false;
    			}
    			break;
    		case "jce":
    			$jceVersion = $this->getJceInstalledVersion();
    			$isMissing = true;
    			
    			if($jceVersion !== null) {
					$jceVersionCompare = version_compare($jceVersion,'2.6','<'); // read $jceVersion < 2.6
	        		
	        		if($jceVersionCompare === true ) {
	        			// jce Version is < 2.6
	        			if ( file_exists(JPATH_ROOT . "/components/com_jce/editor/tiny_mce/plugins/nge/nge.php") ) {
	        				$isMissing = false	;					
						}
	        		}
	        		else {
	        			// jce version is >= 2.6
	        			if ( file_exists(JPATH_ROOT . "/plugins/jce/editor-nge/editor_plugin.js") ) {
	        				$isMissing = false	;					
						}
	        		}					
				}

    			break;
    		case "jckeditor":
    			if ( !file_exists(JPATH_ROOT . "/plugins/editors/jckeditor/plugins/nge/plugin.js")){
    				$isMissing = true;
    			}else{
    				$isMissing = false;
    			}
    			break;
            case "arkeditor" :
                if ( !file_exists(JPATH_ROOT . "/plugins/arkeditor/nextgeneditor")){
    				$isMissing = true;
    			}else{
    				$isMissing = false;
    			}
                break;
    		default:
    			$isMissing = null;
    			break;
    	}
    		
    	return $isMissing;
    }
    
    protected function isEnabledNgePlugin($key, $value = "", $pluginParams){
    	$isEnabled = false;
    
    	switch ($key) {
    		case "tinymce":
    			if(isset($pluginParams) && !empty($pluginParams)){
		            $params = new JRegistry();
		            $params->loadString($pluginParams->params);
    				$tinyMceForJ37 = $params->get('configuration.setoptions',null);
		            // test if tinyMce plugin params field is in J37 format or not
		            if($tinyMceForJ37!==null) {
		            	$isEnabled = false;
		            	foreach($tinyMceForJ37 as $set) {
							if ( (isset($set->custom_plugin) && stripos($set->custom_plugin, 'nge') !== FALSE)
	                            && (isset($set->custom_button) && stripos($set->custom_button, 'nge') !== FALSE)) {
	    						$isEnabled = true;
	    					}
						}
						
					} 
					else {
						$custom_plugin = $params->get('custom_plugin','');
						$custom_button = $params->get('custom_button','');
	    				if ( stripos($custom_plugin, 'nge') !== FALSE
	                            && stripos($custom_button, 'nge') !== FALSE) {
	    					$isEnabled = true;
	    				}else{
	    					$isEnabled = false;
	    				}
	    			}
    			}else{
    				$isEnabled = false;
    			}
    			break;
    		case "jckeditor":
    			if(isset($pluginParams) && !empty($pluginParams)){
    				$isEnabled = $this->isJckPluginEnabled();
    			}else{
    				$isEnabled = false;
    			}
    			break;
   			case "arkeditor":
    			if(isset($pluginParams) && !empty($pluginParams)){
    				$isEnabled = $this->isArkPluginEnabled();
    			}else{
    				$isEnabled = false;
    			}
    			break;
   			case "jce":
   				$jceVersion = $this->getJceInstalledVersion();
   				
				if($jceVersion !== null) {
        		
	        		$isEnabled = false;
	        		
	        		$jceVersionCompare = version_compare($jceVersion,'2.6','<'); // read $jceVersion < 2.6
	        		
	        		
	        		if($jceVersionCompare === true ) {
	        			// jce Version is < 2.6
	        			$isEnabled = $this->isJceAddonUnderTwoDotSixEnabled();
	        		}
	        		else {
	        			// jce version is >= 2.6
	        			$isEnabled = $this->isJceAddonOverTwoDotSixEnabled();
	        		}
        		}
    			break;
    		default:
    			$isEnabled = null;
    			break;
    	}
    		
    	return $isEnabled;
    }
    
    protected function getJceInstalledVersion() {
		$db = JFactory::getDbo();
		
		// get manifest file cache for com_jce 
		$sql = 'SELECT manifest_cache FROM #__extensions WHERE element="com_jce" LIMIT 0,1';
		$db->setQuery($sql);
		$manifest = $db->loadResult();
		
		$jceVersion = null; // jce is not installed
		if($manifest !== null) { 
			// find db declaration for JCE, then JCE is installed
    		// retrieve com_jce version from Manifest
    		$jceManifest = json_decode($manifest);
    		$jceVersion = $jceManifest->version;
			
		}
		
		return $jceVersion;
		
	}

    protected function isJceAddonUnderTwoDotSixEnabled() {
        return $this->isJceAddonEnabledInToolbars();
    }
    
    protected function isJceAddonOverTwoDotSixEnabled() {
        $isEnabled = false;
        $db	= JFactory::getDBO();
        $sql = 'SELECT enabled FROM #__extensions WHERE element="editor-nge" AND folder="jce"';
        $db->setQuery( $sql) ;
        $ngeJcePluginEnabled = $db->loadResult();

        // if plugin editor_nge exist in #__extension and is enable, test if nge exit in jce toolbars.
        // else, $isEnabled == false        
        if ($ngeJcePluginEnabled==1) {
            $isEnabled = $this->isJceAddonEnabledInToolbars();
            
        } 
            
        return $isEnabled;
        
    }
    
    protected function isJceAddonEnabledInToolbars() {
        $db	= JFactory::getDBO();
        $sql = 'SELECT * FROM #__wf_profiles';
        $db->setQuery( $sql) ;
        $jceProfileRecords = $db->loadObjectList();

		$findNgeInToolbars = false;
		foreach($jceProfileRecords as $jceProfile) {
			$rows = $jceProfile->rows;
			$toolbars = explode(';',$jceProfile->rows);
			// search nge in toolbars
			foreach($toolbars as $toolbar) {
				$toolbarButtons = explode(',', $toolbar);
				if(array_search('nge',$toolbarButtons)) {
					$findNgeInToolbars = true;
				}
			}
        }
		
    	return $findNgeInToolbars;
    }
    
    
    protected function getPluginNge($element, $folder = ""){ 	
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true)
    	->select('folder AS type, element AS name, params')
    	->from('#__extensions')
    	->where('element = '.$db->quote($element))
    	->where('folder = '.$db->quote($folder))
    	->where('enabled >= 1')
    	->where('type =' . $db->quote('plugin'))
    	->order('ordering');
    	
    	$result = $db->setQuery($query)->loadObject();
		return $result;
    }
    
    protected function isPluginNgeEnabled($pluginParams){ 	
    	if($pluginParams == null){
    		return false;
    	}else{
    		return true;
    	}
    }
    
}