<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
abstract class NgeXMLHelper {

    public static function getElement($xml, $name, $default = '') {
        if ($xml instanceof JSimpleXML) {
            //if (is_a($xml, 'JSimpleXML')) {
            $element = $xml->document->getElementByPath($name);
            return $element ? $element->data() : $default;
        } else {
            return (string) $xml->$name;
        }
    }

    public static function getElements($xml, $name) {
        if ($xml instanceof JSimpleXML) {
            //if (is_a($xml, 'JSimpleXML')) {
            $element = $xml->document->getElementByPath($name);

            if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
                return $element;
            }
        } else {
            return $xml->$name;
        }

        return array();
    }

    public static function getAttribute($xml, $name, $default = '') {
        //if (is_a($xml, 'JSimpleXML')) {
        if ($xml instanceof JSimpleXML) {
            $value = (string) $xml->document->attributes($name);
        } else {
            $value = (string) $xml->attributes()->$name;
        }

        return $value ? $value : $default;
    }

    public static function getXML($file) {
        return JEPXMLElement::load($file);
    }

    public static function parseInstallManifest($file) {
        $xml = JEPXMLElement::load($file);
        
        if (!$xml) {
            return false;
        }
        
        if ($xml->getName() != 'install' && $xml->getName() != 'extension') {
            return false;
        }
        
        $data = array(
            'version'       => (string) $xml->version,
            'name'          => (string) $xml->name,
            'copyright'     => (string) $xml->copyright,
            'authorEmail'   => (string) $xml->authorEmail,
            'authorUrl'     => (string) $xml->authorUrl,
            'description'   => (string) $xml->description,
            'author'        => (string) $xml->author
        );
        
        return $data;
    }

}