<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Ngestudio
 * @author     Bouillé <administration@teatis.com>
 * @copyright  Copyright (C) 2014. Tous droits réservés.
 * @license    GNU General Public License version 2 ou version ultérieure ; Voir LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Ngestudio helper.
 *
 * @since  1.6
 */
class NgeHelpersNge
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
	    JHtmlSidebar::addEntry(
		JText::_('COM_NGE_SUBMENU_CPANEL'),
		'index.php?option=com_nge',
		$vName == 'nge'
				);
		
		JHtmlSidebar::addEntry(
			JText::_('COM_NGE_SUBMENU_PLUGINS'),
			'index.php?option=com_nge&view=plugins',
			$vName == 'plugins'
		);
		JHtmlSidebar::addEntry(
			JText::_('COM_NGESTUDIO_TITLE_CATEGORIES'),
			'index.php?option=com_ngestudio&view=categories',
			$vName == 'categories'
		);

JHtmlSidebar::addEntry(
			JText::_('COM_NGESTUDIO_TITLE_ITEMS'),
			'index.php?option=com_ngestudio&view=items',
			$vName == 'items'
		);

JHtmlSidebar::addEntry(
			JText::_('COM_NGESTUDIO_TITLE_PARTS'),
			'index.php?option=com_ngestudio&view=parts',
			$vName == 'parts'
		);

JHtmlSidebar::addEntry(
			JText::_('COM_NGESTUDIO_TITLE_LIBRARYS'),
			'index.php?option=com_ngestudio&view=librarys',
			$vName == 'librarys'
		);

JHtmlSidebar::addEntry(
			JText::_('COM_NGESTUDIO_TITLE_PATTERNS'),
			'index.php?option=com_ngestudio&view=patterns',
			$vName == 'patterns'
		);

	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_ngestudio';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}


class NgeHelper extends NgeHelpersNge
{

}
