<?php
/**
* @package     NextGenEditor
*
* @copyright   Copyright (C) Teatis. All rights reserved.
* @license     GNU General Public License version 2 or later; see LICENSE.txt
* @author      TEATIS - www.nextgeneditor.com
*/
// no direct access
defined('_JEXEC') or die;

jimport('joomla.filesystem.folder');

/**
* ngeHelperTinymceInstaller
*/
class ngeHelperTinymceInstaller extends JHelper
{

	static public $errorCopyMsg = '';

	/**
	* Install NGE for TinyMCE file and db declaration
	* @param bool $declarePlugin      on update nge component, only copy files
	*
	* @return
	*/
	static function installAddon($declarePlugin = false)
	{
		$srcMediaFolder = JPATH_ROOT . "/media/com_nge/editors";	    
		$srcFolder      = $srcMediaFolder . "/ngetinymce";
		if (version_compare(JVERSION, '4') < 0)
		    $destFolder     = JPATH_ROOT . "/media/editors/tinymce/plugins/nge";
		else 
		    $destFolder     = JPATH_ROOT . "/media/vendor/tinymce/plugins/nge";		
		$isCopyOk       = self::copyEditorFiles($srcFolder, $destFolder);
		
		if(!$isCopyOk)
		{
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_TINYMCE_ERROR_COPY_FILES') . self::$errorCopyMsg, 'notice');
			return false;
		}
		else
		{

			// get tinyMCE plugin params to add nge button
			$db            = JFactory::getDBO();
			$sql           = 'SELECT * FROM #__extensions WHERE name = "plg_editors_tinymce" ';
			$db->setQuery($sql);
			$tinyrecord    = $db->loadObject();

			$params        = new JRegistry();
			$params->loadString($tinyrecord->params);

			// if Joomla 3.7, param configuration.setoptions exist
			$tinyMceForJ37 = $params->get('configuration.setoptions', null);

			if($declarePlugin) // in install mode, declare nge button in toolbars
			{
				// test if tinyMce plugin params field is in J37 format or not
				if($tinyMceForJ37 !== null)
				{
					// set mode to 2 (extend)
					$params->set('mode', 2);
					// add nge in toolbars
;
					$i=0;
					foreach($tinyMceForJ37 as $set){
						if(strlen($set->custom_plugin) > 0)
						{
							if(strpos($set->custom_plugin, 'nge') === false)
							$set->custom_plugin .= ',nge';
						}
						else
						$set->custom_plugin = 'nge';

						// add custom button in toolbar
						if(strlen($set->custom_button) > 0)
						{
							if(strpos($set->custom_button, 'nge') === false)
							$set->custom_button .= ',nge';
						}
						else
						$set->custom_button = 'nge';

						$params->set('configuration.setoptions.'.$i, $set);
						$i++;
					}
				}
				else // tinyMCE params are in Joomla < 3.7 format
				{
					// set mode to 2 (extend)
					$params->set('mode', 2);
					// add nge custom plugin in tinymce plugin list
					$custom_plugin = $params->get('custom_plugin', '');

					if(strlen($custom_plugin) > 0)
					{
						if(strpos($custom_plugin, 'nge') === false)
						$custom_plugin .= ',nge';
					}
					else
					$custom_plugin = 'nge';

					$params->set('custom_plugin', $custom_plugin);

					// add custom button in toolbar
					$custom_button = $params->get('custom_button', '');
					if(strlen($custom_button) > 0)
					{
						if(strpos($custom_button, 'nge') === false)
						$custom_button .= ',nge';
					}
					else
					$custom_button = 'nge';
					$params->set('custom_button', $custom_button);
				}
				// update bdd
				$sql = "UPDATE #__extensions SET params='" . $params->toString() . "' WHERE name = 'plg_editors_tinymce'";
				$db->setQuery($sql);
				$db->execute();
			} 
			else {
				if($tinyMceForJ37 !== null)
				{
					// set mode to 2 (extend)
					$params->set('mode', 2);
					
					// look in toolbar superadminif nge button exist
					$ngebuttonExistInSUtoolbar = false;
					foreach($tinyMceForJ37 as $set){
						if(array_search(8,$set->access)) {
							if(strpos($set->custom_plugin, 'nge') >0 )
								$ngebuttonExistInSUtoolbar = true;
						}
					}
					
					if(!$ngebuttonExistInSUtoolbar) {
						// add nge in toolbars
						$i=0;
						foreach($tinyMceForJ37 as $set){
							if(strlen($set->custom_plugin) > 0)
							{
								if(strpos($set->custom_plugin, 'nge') === false)
								$set->custom_plugin .= ',nge';
							}
							else
							$set->custom_plugin = 'nge';

							// add custom button in toolbar
							if(strlen($set->custom_button) > 0)
							{
								if(strpos($set->custom_button, 'nge') === false)
								$set->custom_button .= ',nge';
							}
							else
							$set->custom_button = 'nge';

							$params->set('configuration.setoptions.'.$i, $set);
							$i++;
						}
						// update bdd
						$sql = "UPDATE #__extensions SET params='" . $params->toString() . "' WHERE name = 'plg_editors_tinymce'";
						$db->setQuery($sql);
						$db->execute();	
					}
				}
				
				
			} // if $declarePlugin
			return true;
		} // if ! copy ok
	}

	/**
	* ngeHelperTinymceInstaller::uninstallTinyMceAddon()
	* Uninstall nge addon for tinymce file and db déclarations
	* @return void
	*/
	static function uninstallAddon()
	{

		if (version_compare(JVERSION, '4') < 0)
		    $addonFolder = JPATH_ROOT . "/media/editors/tinymce/plugins/nge";
		else 
		    $addonFolder = JPATH_ROOT . "/media/vendor/tinymce/plugins/nge";
		
		if(JFolder::exists($addonFolder))
		JFolder::delete($addonFolder);

		// deactivate NextGenEditor plugin in tinymce editor
		$db            = JFactory::getDBO();
		$sql           = 'SELECT * FROM #__extensions WHERE name = "plg_editors_tinymce" ';
		$db->setQuery($sql);
		$tinyrecord    = $db->loadObject();

		$params        = new JRegistry();
		$params->loadString($tinyrecord->params);

		$tinyMceForJ37 = $params->get('configuration.setoptions.0', null);
		// test if tinyMce plugin params field is in J37 format or not
		if($tinyMceForJ37 !== null)
		{
			// set mode to 2 (extend)
			$params->set('mode', 2);
			// add nge only in Set0
			if(strpos($tinyMceForJ37->custom_plugin, 'nge') >= 0)
			$tinyMceForJ37->custom_plugin = str_replace('nge', '', $tinyMceForJ37->custom_plugin);

			// add custom button in toolbar
			if(strpos($tinyMceForJ37->custom_button, 'nge') >= 0)
			$tinyMceForJ37->custom_button = str_replace('nge', '', $tinyMceForJ37->custom_button);

			$params->set('configuration.setoptions.0', $tinyMceForJ37);
		}
		else
		{
			// custom plugin
			$custom_plugin = $params->get('custom_plugin', '');


			if(strpos($custom_plugin, 'nge') >= 0)
			$custom_plugin = str_replace('nge', '', $custom_plugin);

			$params->set('custom_plugin', $custom_plugin);

			// custom button
			$custom_button = $params->get('custom_button', '');
			if(strpos($custom_button, 'nge') >= 0)
			$custom_button = str_replace('nge', '', $custom_button);

			$params->set('custom_button', $custom_button);
		}
		// update bdd
		$sql = "UPDATE #__extensions SET params='" . $params->toString() . "' WHERE name = 'plg_editors_tinymce'";
		$db->setQuery($sql);
		$db->execute();
	}

	/**
	* copy files for an éditor, create dest directories if not exists
	*
	* @param string $source
	* @param string $dest
	*
	* @return
	*/
	static function copyEditorFiles($source, $dest)
	{

		//$pathObject = new JFilesystemWrapperPath;
		$pathObject      = new JPath;
		// copy files for tinymce editor

		$cleanDestFolder = $pathObject->clean($dest);
		$cleanSrcFolder  = $pathObject->clean($source);

		try
		{
			if(!JFolder::exists($cleanDestFolder))
			JFolder::create($cleanDestFolder);

			// copy with force parameter to true

			JFolder::copy($cleanSrcFolder, $cleanDestFolder, '', true);
			return true;
		} catch(Exception $e)
		{
			self::$errorCopyMsg = $e->getMessage();
			return false;
		}
	}

}
