<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

jimport('joomla.filesystem.folder');

/**
 * ngeHelperJckInstaller
 */
class ngeHelperJckInstaller extends JHelper {

    static public $errorCopyMsg = '';

    /**
     * 
     * Install NGE for JCK Editor file and db declaration
     * @param bool $declarePlugin      on update nge component, only copy files
     * @return bool
     */
    static function installAddon($declarePlugin = false) {

	$srcMediaFolder = JPATH_ROOT . "/media/com_nge/editors";
	$srcFolder = $srcMediaFolder . "/ngejck";
	$destFolder = JPATH_ROOT . "/plugins/editors/jckeditor/plugins/nge";
	$isCopyOk = self::copyEditorFiles($srcFolder, $destFolder);

	if (!$isCopyOk) {
	    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_COPY_FILES') . self::$errorCopyMsg, 'notice');
	    return false;
	} else {

	    if ($declarePlugin) {
		// plugin declaration for JCK Editor
		$db = JFactory::getDBO();


		$errorAddingInTable = false;
		try {
		    //add plugin in #__jckplugins Table
		    $sql = 'INSERT IGNORE INTO #__jckplugins (id,title,name,type,row,icon,published,editable) VALUES (null,"NextGenEditor","nge","plugin",4,"library.png",1,1)';
		    $db->setQuery($sql);
		    $db->execute();
		    $sql = 'UPDATE #__jckplugins SET published=1 WHERE name="nge"';
		    $db->setQuery($sql);
		    $db->execute();

		    $sql = 'SELECT id FROM #__jckplugins WHERE name="nge"';
		    $db->setQuery($sql);

		    $pluginId = $db->loadResult();

		    if (!$pluginId) {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TABLE'), 'notice');
			$errorAddingInTable = true;
		    }
		} catch (Exception $e) {
		    $errorAddingInTable = true;
		}


		// add jck button in all toolbars
		if (!$errorAddingInTable) {
		    $ckPluginDir = JPATH_PLUGINS . '/editors/jckeditor/jckeditor/includes/ckeditor';
		    require_once($ckPluginDir . '/toolbar.php');
		    require_once($ckPluginDir . '/plugins.php');

		    // declare nge plugin in toolbarplugins.php class
		    require_once($ckPluginDir . '/plugins/toolbarplugins.php');
		    $toolbarPlugin = new JCKToolbarPlugins();
		    if (!isset($toolbarPlugin->nge)) {
			//fix toolbar values or they will get wiped out
			foreach (get_object_vars($toolbarPlugin) as $k => $v) {

			    if (is_null($v)) {
				$toolbarPlugin->$k = '';
			    }

			    if ($k[0] == '_')
				$toolbarPlugin->$k = NULL;
			}
			$toolbarPlugin->nge = '1';
			$toolbarPluginConfig = new JRegistry();
			$toolbarPluginConfig->loadObject($toolbarPlugin);
			$cfgFile = $ckPluginDir . '/plugins/toolbarplugins.php';
			if (!JFile::write($cfgFile, $toolbarPluginConfig->toString('PHP', array('class' => 'JCKToolbarPlugins extends JCKPlugins')))) {
			    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR'), 'warning');
			}
		    }

		    //declare button for each toolbar
		    $sql = 'SELECT * FROM #__jcktoolbars';
		    $db->setQuery($sql);
		    $jckToolbars = $db->loadObjectList();

		    foreach ($jckToolbars as $jckToolbar) {
			$sql = 'INSERT IGNORE INTO #__jcktoolbarplugins VALUES (' . $jckToolbar->id . ', ' . $pluginId . ',20,1,1)';
			$db->setQuery($sql);
			try {
			    $db->execute();

			    // declare nge button in toolbars config Files    	
			    require($ckPluginDir . '/toolbar/' . $jckToolbar->name . '.php');
			    $classname = 'JCK' . ucfirst($jckToolbar->name);

			    $toolbar = new $classname();
			    //fix toolbar values or they will get wiped out
			    foreach (get_object_vars($toolbar) as $k => $v) {

				if (is_null($v)) {
				    $toolbar->$k = '';
				}

				if ($k[0] == '_')
				    $toolbar->$k = NULL;
			    }
			    $toolbar->NextGenEditor = '';
			    $toolbarConfig = new JRegistry('toolbar');
			    $toolbarConfig->loadObject($toolbar);
			    $tmpfilename = $ckPluginDir . '/toolbar/' . $jckToolbar->name . '.php';
			    // Get the config registry in PHP class format and write it to configuation.php
			    if (!JFile::write($tmpfilename, $toolbarConfig->toString('PHP', array('class' => $classname . ' extends JCKToolbar')))) {
				JCKHelper::raiseWarning('', JText::sprintf('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR' . ' ' . $jckToolbar->title));
			    }
			} catch (Exception $e) {
			    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR') . ' ' . $jckToolbar->title, 'notice');
			}
		    }
		    $result = true;
		} else {

		    $result = false;
		}
	    }  // if $onlyCopy
	    return $result;
	} // if ! copy ok		
    }

    /**
     * ngeHelperJckInstaller::uninstallJckAddon()
     * Uninstall nge addon for JCK editor file and db déclarations 
     * @return void
     */
    static function uninstallAddon() {
	$addonFolder = JPATH_ROOT . "/plugins/editors/jckeditor/plugins/nge";
	if (JFolder::exists($addonFolder)) {
	    JFolder::delete($addonFolder);

	    // delete table entry
	    $db = JFactory::getDBO();
	    $sql = 'DELETE FROM #__jckplugins WHERE name="nge" AND type="plugin"';
	    $db->setQuery($sql);
	    $db->execute();
	    $sql = 'DELETE FROM #__jcktoolbarplugins WHERE pluginid NOT IN (SELECT id FROM #__jckplugins)';
	    $db->setQuery($sql);
	    $db->execute();

	    $ckPluginDir = JPATH_PLUGINS . '/editors/jckeditor/jckeditor/includes/ckeditor';
	    require_once($ckPluginDir . '/toolbar.php');
	    require_once($ckPluginDir . '/plugins.php');

	    // undeclare nge plugin in toolbarplugins.php class
	    require_once($ckPluginDir . '/plugins/toolbarplugins.php');
	    $toolbarPlugin = new JCKToolbarPlugins();
	    if (isset($toolbarPlugin->nge)) {
		//fix toolbar values or they will get wiped out
		foreach (get_object_vars($toolbarPlugin) as $k => $v) {

		    if (is_null($v)) {
			$toolbarPlugin->$k = '';
		    }

		    if ($k[0] == '_')
			$toolbarPlugin->$k = NULL;
		}
		$toolbarPlugin->nge = NULL;
		$toolbarPluginConfig = new JRegistry();
		$toolbarPluginConfig->loadObject($toolbarPlugin);
		$cfgFile = $ckPluginDir . '/plugins/toolbarplugins.php';
		if (!JFile::write($cfgFile, $toolbarPluginConfig->toString('PHP', array('class' => 'JCKToolbarPlugins extends JCKPlugins')))) {
		    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR'), 'warning');
		}
	    }

	    // undeclare button for each toolbar
	    $sql = 'SELECT * FROM #__jcktoolbars';
	    $db->setQuery($sql);
	    $jckToolbars = $db->loadObjectList();

	    foreach ($jckToolbars as $jckToolbar) {
		try {

		    // undeclare nge button in toolbars config Files    	
		    require($ckPluginDir . '/toolbar/' . $jckToolbar->name . '.php');
		    $classname = 'JCK' . ucfirst($jckToolbar->name);

		    $toolbar = new $classname();
		    //fix toolbar values or they will get wiped out
		    foreach (get_object_vars($toolbar) as $k => $v) {

			if (is_null($v)) {
			    $toolbar->$k = '';
			}

			if ($k[0] == '_')
			    $toolbar->$k = NULL;
		    }
		    $toolbar->NextGenEditor = NULL;
		    $toolbarConfig = new JRegistry('toolbar');
		    $toolbarConfig->loadObject($toolbar);
		    $tmpfilename = $ckPluginDir . '/toolbar/' . $jckToolbar->name . '.php';
		    // Get the config registry in PHP class format and write it to configuation.php
		    if (!JFile::write($tmpfilename, $toolbarConfig->toString('PHP', array('class' => $classname . ' extends JCKToolbar')))) {
			JCKHelper::raiseWarning('', JText::sprintf('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR' . ' ' . $jckToolbar->title));
		    }
		} catch (Exception $e) {
		    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_ERROR_ADD_PLUGIN_IN_TOOLBAR') . ' ' . $jckToolbar->title, 'notice');
		}
	    }
	}
    }

    /**
     * copy files for an éditor, create dest directories if not exists
     * 
     * @param string $source
     * @param string $dest
     * 
     * @return
     */
    static function copyEditorFiles($source, $dest) {

	//$pathObject = new JFilesystemWrapperPath;
	$pathObject = new JPath;
	// copy files for tinymce editor

	$cleanDestFolder = $pathObject->clean($dest);
	$cleanSrcFolder = $pathObject->clean($source);

	try {
	    if (!JFolder::exists($cleanDestFolder))
		JFolder::create($cleanDestFolder);

	    // copy with force parameter to true

	    JFolder::copy($cleanSrcFolder, $cleanDestFolder, '', true);
	    return true;
	} catch (Exception $e) {
	    self::$errorCopyMsg = $e->getMessage();
	    return false;
	}
    }

}
