<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

jimport('joomla.filesystem.folder');

/**
 * ngeHelperJceInstaller
 */
class ngeHelperJceInstaller extends JHelper {

    static public $errorCopyMsg = '';

    /**
     * ngeHelperJceInstaller::installJceAddon()
     * Install addon for JCE Editor
     * @param bool $declarePlugin
     * @return
     */
    static function installAddon($declarePlugin = false) {
	$db = JFactory::getDbo();

	// get manifest file cache for com_jce 
	$sql = 'SELECT manifest_cache FROM #__extensions WHERE element="com_jce" LIMIT 0,1';
	$db->setQuery($sql);
	$manifest = $db->loadResult();

	// retrieve com_jce version from Manifest
	$jceManifest = json_decode($manifest);
	$jceVersion = $jceManifest->version;
	$jceVersionCompare = version_compare($jceVersion, '2.6', '<'); // read $jceVersion < 2.6

	if ($jceVersionCompare === true) {
	    // jce Version is < 2.6
	    return self::installJceAddonUnderTwoDotSix($declarePlugin);
	} else {
	    // jce version is >= 2.6
	    return self::installJceAddonOverTwoDotSix($declarePlugin);
	}
	return false;
    }

    
/**
     * ngeHelperJceInstaller::uninstallJceAddon()
     * UnInstall addons for JCE Editor
     * @return
     */
    static function uninstallAddon() {    
	self::uninstallJceAddonUnderTwoDotSix();
	self::uninstallJceAddonOverTwoDotSix();
    }
    
        
    /**
     * Install NGE for JCE < 2.6 file and db declaration
     * @param bool $declarePlugin      on update nge component, only copy files
     * 
     * @return bool
     */
    static function installJceAddonUnderTwoDotSix($declarePlugin = false) {
	$srcMediaFolder = JPATH_ROOT . "/media/com_nge/editors";
	$srcFolder = $srcMediaFolder . "/ngejce25";
	$destFolder = JPATH_ROOT . "/components/com_jce/editor/tiny_mce/plugins/nge";
	$isCopyOk = self::copyEditorFiles($srcFolder, $destFolder);

	if (!$isCopyOk) {
	    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCE_ERROR_COPY_FILES') . self::$errorCopyMsg, 'notice');
	    return false;
	} else {

	    if ($declarePlugin) {
		// add plugin and button in each jce profiles
		$db = JFactory::getDBO();
		$sql = 'SELECT * FROM #__wf_profiles';
		$db->setQuery($sql);
		$jceProfileRecords = $db->loadObjectList();

		foreach ($jceProfileRecords as $jceProfile) {
		    $rows = $jceProfile->rows;
		    $toolbars = explode(';', $jceProfile->rows);
		    $findNgeInToolbars = false;
		    // search nge in toolbars
		    foreach ($toolbars as $toolbar) {
			$toolbarButtons = explode(',', $toolbar);
			if (array_search('nge', $toolbarButtons)) {
			    $findNgeInToolbars = true;
			}
		    }
		    // nge not already in toolbars, add it
		    if (!$findNgeInToolbars)
			$rows .= ',nge';

		    // add nge in plugins list
		    $plugins = explode(',', $jceProfile->plugins);
		    if (!array_search('nge', $plugins)) {
			array_push($plugins, 'nge');
		    }
		    $plugins = implode(',', $plugins);

		    // update DB
		    $sql = "UPDATE #__wf_profiles SET rows='" . $rows . "', plugins='" . $plugins . "' WHERE id = " . $jceProfile->id;
		    $db->setQuery($sql);
		    $db->execute();
		}
	    }  // if $onlyCopy
	    return true;
	} // if ! copy ok		
    }

    /**
     * ngeHelperJceInstaller::uninstallJceAddonUnderTwoDotSix()
     * Uninstall nge addon for JCE < 2.6 file and db déclarations 
     * @param bool $declarePlugin
     * @return void
     */
    static function uninstallJceAddonUnderTwoDotSix() {
	$addonFolder = JPATH_ROOT . "/components/com_jce/editor/tiny_mce/plugins/nge";
	if (JFolder::exists($addonFolder)) {
	    jFolder::delete($addonFolder);

	    // delete plugin and button in each jce profiles
	    $db = JFactory::getDBO();
	    $sql = 'SELECT * FROM #__wf_profiles';
	    $db->setQuery($sql);
	    $jceProfileRecords = $db->loadObjectList();

	    foreach ($jceProfileRecords as $jceProfile) {
		$rows = $jceProfile->rows;
		$rows = str_replace('nge', '', $rows);

		$plugins = $jceProfile->plugins;
		$plugins = str_replace('nge', '', $plugins);
		// update DB
		$sql = "UPDATE #__wf_profiles SET rows='" . $rows . "', plugins='" . $plugins . "' WHERE id = " . $jceProfile->id;
		$db->setQuery($sql);
		$db->execute();
	    }
	} // if folder exist		
    }

    /**
     * Install NGE for JCE >= 2.6 file and db declaration
     * @param bool $declarePlugin      on update nge component, only copy files
     * 
     * @return bool
     */
    static function installJceAddonOverTwoDotSix($declarePlugin = false) {
        // first testing and deleting if exist plugin for JCE < 2.6
       	$JCE25addonFolder = JPATH_ROOT . "/components/com_jce/editor/tiny_mce/plugins/nge";
    	if (JFolder::exists($JCE25addonFolder)) {
    	    jFolder::delete($JCE25addonFolder);
         }

	// copy in plugins/jce/nge
	$srcMediaFolder = JPATH_ROOT . "/media/com_nge/editors";
	$srcFolder = $srcMediaFolder . "/ngejce26";
	$destFolder = JPATH_ROOT . "/plugins/jce";
	if (!JFolder::exists($destFolder)) {
	    JFolder::create($destFolder);
	}
	$destFolder = $destFolder . '/editor-nge';
	$isCopyOk = self::copyEditorFiles($srcFolder, $destFolder);

	// copy in components/com_jce/editor/tiny_mce
	$destFolder = JPATH_ROOT . "/components/com_jce/editor/tiny_mce/plugins/nge";
	$isCopyInEditorOk = self::copyEditorFiles($srcFolder, $destFolder);


	if (!$isCopyOk || !$isCopyInEditorOk) {
	    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCE_ERROR_COPY_FILES') . self::$errorCopyMsg, 'notice');
	    return false;
	} else {

		$db = JFactory::getDBO();
		// insert and activate nge jce addon plugin in Joomla
		//$sql = 'UPDATE #__extensions SET enabled=1 WHERE element="editor-nge" AND type="plugin" AND folder="jce"';

		// verify if plugin exist in #__extension table
		$sqlCount = 'SELECT COUNT(*) FROM #__extensions WHERE type=\'plugin\' AND element=\'editor-nge\' AND folder=\'jce\'';
		$db->setQuery($sqlCount);
		$existInExtensionsTable = $db->loadResult();

		// plugin not exist in extension table, adding it
		if($existInExtensionsTable==0) {
			$sql = 'INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
		    (null, \'NGE addon for JCE\', \'plugin\', \'editor-nge\', \'jce\', 0, 1, 1, 0, \'{"name":"NGE addon for JCE","type":"plugin","creationDate":"January 2016","author":"Teatis","copyright":"Copyright (C) Teatis. All rights reserved.","authorEmail":"contact@nextgeneditor.com","authorUrl":"http:\\/\\/www.nextgeneditor.com","version":"1.1.0","description":"","group":"","filename":"editor-nge"}\', \'{}\', \'\', \'\', 0, \'0000-00-00 00:00:00\', 0, 0);';
    
    		$db->setQuery($sql);
    		$db->execute();            
        }
        
	    if ($declarePlugin) {



    		// always enable plugin
    		$sql = 'UPDATE #__extensions SET enabled=1 WHERE element="editor-nge" AND folder="jce"';
    		$db->setQuery($sql);
    		$db->execute();
    
    
    		// add plugin and button in each jce profiles
    		$sql = 'SELECT * FROM #__wf_profiles';
    		$db->setQuery($sql);
    		$jceProfileRecords = $db->loadObjectList();
    
    		foreach ($jceProfileRecords as $jceProfile) {
    		    $rows = $jceProfile->rows;
    		    $toolbars = explode(';', $jceProfile->rows);
    		    $findNgeInToolbars = false;
    		    // search nge in toolbars
    		    foreach ($toolbars as $toolbar) {
    			$toolbarButtons = explode(',', $toolbar);
    			if (array_search('nge', $toolbarButtons)) {
    			    $findNgeInToolbars = true;
    			}
    		    }
    		    // nge not already in toolbars, add it
    		    if (!$findNgeInToolbars)
    			$rows .= ',nge';
    
    		    // add nge in plugins list
    		    $plugins = explode(',', $jceProfile->plugins);
    		    if (!array_search('nge', $plugins)) {
    			array_push($plugins, 'nge');
    		    }
    		    $plugins = implode(',', $plugins);
    
    		    // update DB	
    		    $sql = "UPDATE #__wf_profiles SET rows='" . $rows . "', plugins='" . $plugins . "' WHERE id = " . $jceProfile->id;
    		    $db->setQuery($sql);
    		    $db->execute();
    		}
	    }
	}

	return true;
    }

    /**
     * ngeHelperJceInstaller::uninstallJceAddonOverTwoDotSix()
     * Uninstall nge addon for JCE >= 2.6 file and db déclarations 
     * @return void
     */
    static function uninstallJceAddonOverTwoDotSix() {
	$addonFolder = JPATH_ROOT . "/plugins/jce/editor-nge";
	if (JFolder::exists($addonFolder)) {
	    jFolder::delete($addonFolder);

	    // delete plugin declaration in plugin table
	    $db = JFactory::getDBO();
	    $sql = 'DELETE FROM #__extensions WHERE type="plugin" AND element="editor-nge" AND folder="jce"';
	    $db->setQuery($sql);
	    $db->execute();

	    // delete plugin and button in each jce profiles
	    $db = JFactory::getDBO();
	    $sql = 'SELECT * FROM #__wf_profiles';
	    $db->setQuery($sql);
	    $jceProfileRecords = $db->loadObjectList();

	    foreach ($jceProfileRecords as $jceProfile) {
		$rows = $jceProfile->rows;
		$rows = str_replace('nge', '', $rows);

		$plugins = $jceProfile->plugins;
		$plugins = str_replace('nge', '', $plugins);
		// update DB
		$sql = "UPDATE #__wf_profiles SET rows='" . $rows . "', plugins='" . $plugins . "' WHERE id = " . $jceProfile->id;
		$db->setQuery($sql);
		$db->execute();
	    }
	} // if folder exist		
    }

    /**
     * copy files for an éditor, create dest directories if not exists
     * 
     * @param string $source
     * @param string $dest
     * 
     * @return
     */
    static function copyEditorFiles($source, $dest) {

	//$pathObject = new JFilesystemWrapperPath;
	$pathObject = new JPath;
	// copy files for tinymce editor

	$cleanDestFolder = $pathObject->clean($dest);
	$cleanSrcFolder = $pathObject->clean($source);

	try {
	    if (!JFolder::exists($cleanDestFolder))
		JFolder::create($cleanDestFolder);

	    // copy with force parameter to true

	    JFolder::copy($cleanSrcFolder, $cleanDestFolder, '', true);
	    return true;
	} catch (Exception $e) {
	    self::$errorCopyMsg = $e->getMessage();
	    return false;
	}
    }

}
