<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
jimport('joomla.application.component.controlleradmin');

/**
 * Partss list controller class.
 */
class NgeControllerInstall extends JControllerAdmin {
    
    public function add() {
		$this->setRedirect(JRoute::_('index.php?option=com_nge&view=install', false));
	}
    
    public function install() {
		// Check for request forgeries
		//JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$model = $this->getModel('install');
		if ($model->install())
		{
			$cache = JFactory::getCache('mod_menu');
			$cache->clean();
			// TODO: Reset the users acl here as well to kill off any missing bits
		}

		$app = JFactory::getApplication();
		$redirect_url = '';
		if (empty($redirect_url))
		{
			$redirect_url = JRoute::_('index.php?option=com_nge&view=plugins', false);
		} else
		{
			// wipe out the user state when we're going to redirect
			$app->setUserState('com_installer.redirect_url', '');
			$app->setUserState('com_installer.message', '');
			$app->setUserState('com_installer.extension_message', '');
		}
		$this->setRedirect($redirect_url);
    }
    
    public function uninstall() {
		print_r($this->input);
		$eid   = $this->input->get('cid', array(), 'array');
		$model = $this->getModel('install');

		foreach($eid as $k=>$name) {
			$model->uninstall($name);
			
		}
		$this->setRedirect(JRoute::_('index.php?option=com_nge&view=plugins', false));

	}
}

?>