<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once JPATH_COMPONENT . '/controller.php';

/**
 * NgeControllerField_select
 * 
 * @package NextGenEditor
 * @author Texier Bertrand
 * @copyright 2016
 * @access public
 */
class NgeControllerField_select extends NgeController
{

    /**
     * NgeControllerField_select::getlist()
     * 
     * @param mixed $target
     * @param mixed $search
     * @return print a json for select2 field
     */
    public function getlist($target = '', $search = '') {

	if(JFactory::getSession()->checkToken('get')===false) {
	    header("HTTP/1.0 403 Forbidden");
	    exit(JText::_('JINVALID_TOKEN'));
	}	
		
	// no target in params, search in $_REQUEST
	if(!$target) 
	    $target = JFactory::getApplication()->input->get('target');
	// no search in params, search in $_REQUEST
	if(!$search) 
	    $search = JFactory::getApplication()->input->get('search');

	// call helper ngefield to get list
	require_once(NGEPATH_HELPERS.'/forms/fields/ngefields.php');
	$select_list = NgeFields::getListForSelectField($target, $search);

	print(json_encode($select_list));
	exit();    
    }
}