<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;

class JEPXMLElement extends SimpleXMLElement {

    public static function getXML($data) {
        return self::load($data);
    }
    
    /**
     * Reads a XML file.
     *
     * @param string  $data   Full path and file name.
     *
     * @return mixed WFXMLElement on success | false on error.
     */
    public static function load($data) {
        // Disable libxml errors and allow to fetch error information as needed
        libxml_use_internal_errors(true);

        if (is_file($data)) {
            // Try to load the xml file
            $xml = simplexml_load_file($data);
        } else {
            // Try to load the xml string
            $xml = simplexml_load_string($data);
        }

        if (empty($xml)) {
            // There was an error
	NGE::message(JText::_('ERROR_XML_LOAD'), 'warning');

            if (is_file($data)) {
	NGE::message($data, 'warning');
            }

            foreach (libxml_get_errors() as $error) {
	NGE::message('XML: ' . $error->message, 'warning');
            }
        }

        return $xml;
    }
}