<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
defined('JPATH_BASE') or die('RESTRICTED');
require_once(__DIR__.'/../helpers/xml.php');
/**
 * JCE Plugin installer
 *
 * @package   JCE
 * @subpackage  Installer
 * @since   1.5
 */
class  NgeInstallerNge_Pack extends JObject {

    /**
     * Constructor
     *
     * @param object  $parent Parent object [JInstaller instance]
     * @return  void
     */
    public function __construct($parent) {
        $this->parent = $parent;
    }

    private function setManifest() {
        $manifest = $this->parent->getManifest();
        
        if (!$manifest) {
            return false;
        }

        $values = array('name', 'description',  'icon');

        foreach ($values as $value) {
            $this->parent->set($value, NgeXMLHelper::getElement($manifest, $value));
        }

        $attributes = array('version', 'plugin', 'group', 'type', 'folder', 'row', 'extension');

        foreach ($attributes as $attribute) {
            $this->set($attribute, NgeXMLHelper::getAttribute($manifest, $attribute));
        }

        $elements = array('files', 'languages', 'media','administration','install', 'uninstall','update','pack_version');

        foreach ($elements as $element) {
            $this->set($element, NgeXMLHelper::getElements($manifest, $element));
        }
    }

    /**
     * Install method
     *
     * @access  public
     * @return  boolean True on success
     */
    public function install() {
        // Get a database connector object
        $db = $this->parent->getDBO();
        $this->setManifest();

        $plugin = $this->get('plugin');
        $group = $this->get('group');
        $type = $this->get('type');
        $folder = $this->get('folder');
        $packageVersion = (string)$this->get('pack_version');

        $extension = $this->get('extension');

        // Nge Plugin
        if (!empty($plugin) ) {
        	// compare la version du plugin
        	$sql = "SELECT version_id FROM #__schemas sh LEFT JOIN #__extensions ex ON sh.extension_id=ex.extension_id WHERE ex.name='com_nge'";
        	$db->setQuery($sql);
        	$version = $db->loadResult();
		
            // plugin version must be > to com_nge minor version.
            // com_nge version 1.0.2 is convert to 1.0 and compare to plugin version witch must be > 1.0
            $version_array = explode('.',$version);
            if(!isset($version_array[1]))
                $version_array[1]=0;
            $componentVersion = $version_array[0].'.'.$version_array[1];
            if (version_compare((string) $packageVersion, $componentVersion, '<')) {
                $this->parent->abort(JText::_('NGE_INSTALLER_INCORRECT_VERSION') . '<br/>NGE : '. $componentVersion . ' / ADDON ' . $plugin . ' : ' . $packageVersion);
                return false;
            }

                           
        } else {

                $this->parent->abort(JText::_('NGE_INSTALLER_EXTENSION_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_NO_PLUGIN_FILE'));
                return false;
        }
        
        // component path

		// install path

     // Set overwrite flag if not set by Manifest
        $this->parent->setOverwrite(true);


        // Copy all necessary files
        $this->parent->setPath('extension_root', JPATH_SITE.'/components/com_nge');
        if ($this->parent->parseFiles($this->get('files'), -1)===false) {
            // Install failed, roll back changes
            $this->parent->abort();
            return false;
        }
        
        // copy layouts files
	//Joomla installation copy layout files in administrator directoties.
	//We need to copy them in the main layout directory
        $src_layouts_path = $this->parent->getPath('extension_root').'/layouts';
        $dest_layout_path = JPATH_SITE.'/layouts/nge';
	
        if(!is_dir($dest_layout_path))
        	mkdir($dest_layout_path);
            
        if(is_dir($src_layouts_path)) {
	    JFolder::copy($src_layouts_path, $dest_layout_path, '', true, true);
	    JFolder::delete($src_layouts_path);
	}

        // install administration files
        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');
        $administration_files = $this->get('administration',-1);
        //print_r($administration_files->files);
        //exit();
        if ($this->parent->parseFiles($administration_files->files, -1)===false) {
            // Install failed, roll back changes
            $this->parent->abort();
            return false;
        }
        
        
        // install frontend languages
        $this->parent->parseLanguages($this->get('languages'), 0);
        
        // install backend languages
        $this->parent->parseLanguages($administration_files->languages, 1);
        
        // install media
        $this->parent->parseMedia($this->get('media'), 0);



		// Execute SQL Script
		// first test if pack exist
		$sql = "SELECT count(*) FROM #__nge_plugins WHERE name='$plugin'";
		$db->setQuery($sql);
		$pack_exists = $db->loadResult();
		
		if($pack_exists) {
			// SQL script execution
	        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');
	        $sql_files = $this->get('update',-1);
	        //print_r($administration_files->files);
	        //exit();
	        if ($this->parent->parseSQLFiles($sql_files->sql, -1)===false) {
	            // Install failed, roll back changes
	            $this->parent->abort();
	            return false;
	        }			
		}
		else {
			// SQL script execution
	        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');
	        $sql_files = $this->get('install',-1);
	        //print_r($administration_files->files);
	        //exit();
	        if ($this->parent->parseSQLFiles($sql_files->sql, -1)===false) {
	            // Install failed, roll back changes
	            $this->parent->abort();
	            return false;
	        }			
		}

        // Load the language file
        //$language = JFactory::getLanguage();
        //$language->load('com_jce_' . trim($plugin), JPATH_SITE);

/*        $install = (string) $this->get('install.script');

        if ($install) {
            // Make sure it hasn't already been copied (this would be an error in the xml install file)
            if (!file_exists($this->parent->getPath('extension_root') . '/' . $install)) {
                $path['src']    = $this->parent->getPath('source') . '/' . $install;
                $path['dest']   = $this->parent->getPath('extension_root') . '/' . $install;
                if (!$this->parent->copyFiles(array($path))) {
                    // Install failed, rollback changes
                    $this->parent->abort(JText::_('NGE_INSTALLER_PLUGIN_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_PHP_INSTALL_FILE_ERROR'));
                    return false;
                }
            }
        }

        $uninstall = $this->get('uninstall.script');

        if ($uninstall) {
            // Make sure it hasn't already been copied (this would be an error in the xml install file)
            if (!file_exists($this->parent->getPath('extension_root') . '/' . $uninstall)) {
                $path['src'] = $this->parent->getPath('source') . '/' . $uninstall;
                $path['dest'] = $this->parent->getPath('extension_root') . '/' . $uninstall;
                if (!$this->parent->copyFiles(array(
                            $path
                        ))) {
                    // Install failed, rollback changes
                    $this->parent->abort(JText('INSTALLER_PLUGIN_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_PHP_UNINSTALL_FILE_ERROR'));
                    return false;
                }
            }
        }
*/
        /**
         * ---------------------------------------------------------------------------------------------
         * Finalization and Cleanup Section
         * ---------------------------------------------------------------------------------------------
         */
        // Lastly, we will copy the manifest file to its appropriate place.
        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge/manifest');
        if(!is_dir($this->parent->getPath('extension_root')))
        	mkdir($this->parent->getPath('extension_root'));
        	
        if (!$this->parent->copyManifest(-1)) {
            // Install failed, rollback changes
            $this->parent->abort(JText::_('NGE_INSTALLER_PLUGIN_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_SETUP_COPY_ERROR'));
            return false;
        }
		$this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');

		
        $plugin = new StdClass();
        $plugin->name = $this->get('plugin');
        $plugin->icon = $this->parent->get('icon');
        $plugin->row = (int) $this->get('row');
        $plugin->path = $this->parent->getPath('extension_root');
        $plugin->type = $type;

        //$model = new WFModelPlugins();
       // $model->postInstall('install', $plugin, $this);
        return true;
    }

    /**
     * Uninstall method
     *
     * @access  public
     * @param 	string   $name  The name of the plugin to uninstall
     * @return  boolean True on success
     */
    public function uninstall($name) {
        // Initialize variables
        $row = null;
        $retval = true;
        $db = $this->parent->getDBO();



        // Set the plugin root path
        $this->parent->setPath('extension_root', JPATH_COMPONENT_ADMINISTRATOR);

        // set manifest path
        $manifest = $this->parent->getPath('extension_root') . '/manifest/ngeplugin_pack_' . $name . '.xml'; 

        if (file_exists($manifest)) {
            $xml = NgeXMLHelper::getXML($manifest);

            if (!$xml) {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_PLUGIN_UNINSTALL') . ' : ' . JText::_('NGE_INSTALLER_MANIFEST_INVALID'), 'warning');
            }

            $this->parent->set('name', (string) $xml->name);
            $this->parent->set('version', (string) $xml->pack_version);
            $this->parent->set('message', (string) $xml->description);


			// removes files
			$this->parent->setPath('extension_root', JPATH_COMPONENT_SITE);
			$type = 'nge_pack';
            if ($type == 'nge_pack') {
                //$this->parent->removeFiles($xml->files, -1);
                $this->removeMedia($xml->media, 0);
                $this->parent->removeFiles($xml->languages, 0);
                $this->parent->removeFiles($xml->administration->languages, 1);
                //$this->parent->removeFiles($xml->administration->files, 1);
                
                // remove layout and parts files
                $files = $xml->files->children();
                 foreach($files as $file) {
                     $f = (string) $file;
                     if(!(strpos($f,'layouts')===false)) {
                        JFolder::delete(JPATH_SITE.'/layouts/nge/'.str_replace('layouts/','',$file));
                     }
                     if(!(strpos($f,'parts')===false)) {
                        JFolder::delete(JPATH_COMPONENT_SITE.'/'.$file);
                    }
                 }
                JFile::delete($manifest);
            }


			// SQL script execution
	        $this->parent->setPath('extension_root', JPATH_COMPONENT_ADMINISTRATOR);
	        $sql_files = $xml->uninstall;
	        //print_r($administration_files->files);
	        //exit();
            if ($this->parent->parseSQLFiles($sql_files->sql, -1)===false) {
	            // Install failed, roll back changes
	            $this->parent->abort();
	            $retval = false;
	        }
            
            // delete sql install and uninstall and update pack file
            foreach($xml->install->sql as $file) {
                $f = (string)$file->file;
                JFile::delete(JPATH_COMPONENT_ADMINISTRATOR.'/'.$f);
            }
            foreach($xml->uninstall->sql as $file) {
                $f = (string)$file->file;
                JFile::delete(JPATH_COMPONENT_ADMINISTRATOR.'/'.$f);
            }
            foreach($xml->update->sql as $file) {
                $f = (string)$file->file;
                JFile::delete(JPATH_COMPONENT_ADMINISTRATOR.'/'.$f);
            }
            
            // delete record in nge_plugins
            $sql = "DELETE FROM #__nge_plugins WHERE name='$name'";
            $db->setQuery($sql);
            $db->execute();
            
            
        } else {
            JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_PLUGIN_UNINSTALL') . ' : ' . JText::_('NGE_INSTALLER_MANIFEST_ERROR'), 'warning');
            $retval = false;
        }


        return $retval;
    }

    private function removeMedia($element,$cid=0) {
		if (!$element || !count($element->children()))
		{
			// Either the tag does not exist or has no children therefore we return zero files processed.
			return true;
		}

		$retval = true;

		// Get the client info if we're using a specific client
		if ($cid > -1)
		{
			$client = JApplicationHelper::getClientInfo($cid);
		}
		else
		{
			$client = null;
		}

		// Get the array of file nodes to process
		$files = $element->children();

		if (count($files) == 0)
		{
			// No files to process
			return true;
		}

		$folder = '';


		if ($client)
		{
			
			$source = JPATH_SITE.'/media/com_nge';
			//$this->parent->getPath($pathname);
		}
		else
		{
			$pathname = 'extension_root';
			$source = $this->parent->getPath($pathname);
		}

		// Process each file in the $files array (children of $tagName).
		foreach ($files as $file)
		{
            $path = $source . '/' . $file;

			// Actually delete the files/folders

			if (is_dir($path))
			{
				$val = JFolder::delete($path);
			}
			else
			{
				$val = JFile::delete($path);
			}

			if ($val === false)
			{
				JLog::add('Failed to delete ' . $path, JLog::WARNING, 'jerror');
				$retval = false;
			}
		}

		return $retval;
        
    }
}
