<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
defined('JPATH_BASE') or die('RESTRICTED');
require_once(__DIR__.'/../helpers/xml.php');
/**
 * JCE Plugin installer
 *
 * @package   JCE
 * @subpackage  Installer
 * @since   1.5
 */
class  NgeInstallerNge_Language extends JObject {

    /**
     * Constructor
     *
     * @param object  $parent Parent object [JInstaller instance]
     * @return  void
     */
    public function __construct($parent) {
        $this->parent = $parent;
    }

    private function setManifest() {
        $manifest = $this->parent->getManifest();
        
        if (!$manifest) {
            return false;
        }

        $values = array('name', 'description', 'install.script', 'uninstall.script', 'icon');

        foreach ($values as $value) {
            $this->parent->set($value, NgeXMLHelper::getElement($manifest, $value));
        }

        $attributes = array('version', 'plugin', 'group', 'type', 'folder', 'row', 'extension');

        foreach ($attributes as $attribute) {
            $this->set($attribute, NgeXMLHelper::getAttribute($manifest, $attribute));
        }

        $elements = array('files', 'languages', 'media','administration','install', 'uninstall','update','pack_version');

        foreach ($elements as $element) {
            $this->set($element, NgeXMLHelper::getElements($manifest, $element));
        }
    }

    /**
     * Install method
     *
     * @access  public
     * @return  boolean True on success
     */
    public function install() {
        // Get a database connector object
        $db = $this->parent->getDBO();
        $this->setManifest();

        $plugin = $this->get('plugin');
        $group = $this->get('group');
        $type = $this->get('type');
        $folder = $this->get('folder');
        $packageVersion = (string)$this->get('pack_version');

        $extension = $this->get('extension');

        // Nge Plugin
        if (!empty($plugin) ) {
        	// compare la version du plugin
        	$sql = "SELECT version_id FROM #__schemas sh LEFT JOIN #__extensions ex ON sh.extension_id=ex.extension_id WHERE ex.name='com_nge'";
        	$db->setQuery($sql);
        	$version = $db->loadResult();
        	
            // plugin version must be > to com_nge minor version else error.
            // com_nge version 1.0.2 is convert to 1.0 and compare to plugin version witch must be > 1.0
            $version_array = explode('.',$version);
            if(!isset($version_array[1]))
                $version_array[1]=0;
                
            $componentVersion = $version_array[0].'.'.$version_array[1];
            if (version_compare((string) $packageVersion, $componentVersion, '<')) {
                $this->parent->abort(JText::_('NGE_INSTALLER_INCORRECT_VERSION') . '<br/>NGE : '. $componentVersion . ' / ADDON ' . $plugin . ' : ' . $packageVersion);
                return false;
            }

                           
        } else {

                $this->parent->abort(JText::_('NGE_INSTALLER_EXTENSION_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_NO_PLUGIN_FILE'));
                return false;
        }
        
        // component path

		// install path

     // Set overwrite flag if not set by Manifest
        $this->parent->setOverwrite(true);


        
        
        // install frontend languages
        $this->parent->parseLanguages($this->get('languages'), 0);
        
        // install administration files
        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');
        $administration_files = $this->get('administration',-1);
        // install backend languages
        $this->parent->parseLanguages($administration_files->languages, 1);
        


        /**
         * ---------------------------------------------------------------------------------------------
         * Finalization and Cleanup Section
         * ---------------------------------------------------------------------------------------------
         */
        // Lastly, we will copy the manifest file to its appropriate place.
        $this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge/manifest');
        if(!is_dir($this->parent->getPath('extension_root')))
        	mkdir($this->parent->getPath('extension_root'));
        	
        if (!$this->parent->copyManifest(-1)) {
            // Install failed, rollback changes
            $this->parent->abort(JText::_('NGE_INSTALLER_PLUGIN_INSTALL') . ' : ' . JText::_('NGE_INSTALLER_SETUP_COPY_ERROR'));
            return false;
        }
		$this->parent->setPath('extension_root', JPATH_ADMINISTRATOR.'/components/com_nge');

		
        $plugin = new StdClass();
        $plugin->name = $this->get('plugin');
        $plugin->icon = $this->parent->get('icon');
        $plugin->row = (int) $this->get('row');
        $plugin->path = $this->parent->getPath('extension_root');
        $plugin->type = $type;

        //$model = new WFModelPlugins();
       // $model->postInstall('install', $plugin, $this);
        return true;
    }

    /**
     * Uninstall method
     *
     * @access  public
     * @param 	string   $name  The name of the plugin to uninstall
     * @return  boolean True on success
     */
    public function uninstall($name) {
        // Initialize variables
        $row = null;
        $retval = true;
        $db = $this->parent->getDBO();



        // Set the plugin root path
        $this->parent->setPath('extension_root', JPATH_COMPONENT_ADMINISTRATOR);

        // set manifest path
        $manifest = $this->parent->getPath('extension_root') . '/manifest/ngeplugin_language_' . $name . '.xml'; 

        if (file_exists($manifest)) {
            $xml = NgeXMLHelper::getXML($manifest);

            if (!$xml) {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_PLUGIN_UNINSTALL') . ' : ' . JText::_('NGE_INSTALLER_MANIFEST_INVALID'), 'warning');
            }

            $this->parent->set('name', (string) $xml->name);
            $this->parent->set('version', (string) $xml->pack_version);
            $this->parent->set('message', (string) $xml->description);


			// removes files
			$this->parent->setPath('extension_root', JPATH_COMPONENT_SITE);
			$type = 'nge_language';
            if ($type == 'nge_language') {
                $this->parent->removeFiles($xml->languages, 0);
                $this->parent->removeFiles($xml->administration->languages, 1);

                JFile::delete($manifest);
            }

                        
            // delete record in nge_plugins
            $sql = "DELETE FROM #__nge_plugins WHERE name='$name'";
            $db->setQuery($sql);
            $db->execute();
            
            
        } else {
	JFactory::getApplication()->enqueueMessage(JText::_('NGE_INSTALLER_PLUGIN_UNINSTALL') . ' : ' . JText::_('NGE_INSTALLER_MANIFEST_ERROR'), 'warning');
            $retval = false;
        }


        return $retval;
    }

}
