<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 $lang = JFactory::getApplication()->getLanguage();
 $lang->load('com_jckman');
// no direct access
defined('_JEXEC') or die;

defined('JPATH_BASE') or die('RESTRICTED');
require_once(__DIR__.'/../helpers/xml.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_jckman/tables/plugin.php');
require_once(JPATH_ADMINISTRATOR.'/components/com_jckman/helper.php');

//defines CKEDITOR library includes path
define('CKEDITOR_LIBRARY',JPATH_PLUGINS.'/editors/jckeditor/jckeditor/includes/ckeditor'); 

define('JCK_COMPONENT', JUri::root() . 'administrator/components/com_jckman');
define( 'JCK_PATH', JPATH_PLUGINS.'/editors/jckeditor' );
define( 'JCK_PLUGINS', JCK_PATH.'/plugins' );

/**
 * JCE Plugin installer
 *
 * @package   JCE
 * @subpackage  Installer
 * @since   1.5
 */
class  NgeInstallerNge_Jck extends JObject {

	public $plugin = 'JCK button';
    /**
     * Constructor
     *
     * @param object  $parent Parent object [JInstaller instance]
     * @return  void
     */
    public function __construct($parent) {
        $this->parent = $parent;
    }

    private function setManifest() {
        $manifest = $this->parent->getManifest();
        
        if (!$manifest) {
            return false;
        }

        $values = array('name', 'description',  'icon');

        foreach ($values as $value) {
            $this->parent->set($value, NgeXMLHelper::getElement($manifest, $value));
        }

        $attributes = array('version', 'plugin', 'group', 'type', 'folder', 'row', 'extension');

        foreach ($attributes as $attribute) {
            $this->set($attribute, NgeXMLHelper::getAttribute($manifest, $attribute));
        }

        $elements = array('files', 'languages', 'media','administration','install', 'uninstall','update','pack_version');

        foreach ($elements as $element) {
            $this->set($element, NgeXMLHelper::getElements($manifest, $element));
        }
    }

    /**
     * Install method
     *
     * @access  public
     * @return  boolean True on success
     */
    public function install() {
		// Get a database connector object
		$db =& $this->parent->getDBO();
		$app = JFactory::getApplication();

		// Get the extension manifest object
		$manifest =& $this->parent->getManifest();
		$this->manifest =  $manifest;//$manifest->document;
		
		/**
		 * ---------------------------------------------------------------------------------------------
		 * Manifest Document Setup Section
		 * ---------------------------------------------------------------------------------------------
		 */

		// Set the component name
		$name = '';
				
		if($this->manifest->name)
		{
			$name = $this->manifest->name;
			$this->parent->set('name', (string)$name);
		}
		else
			$this->parent->set('name','');
		
		// Get the component description
		$description = & $this->manifest->description;
		if (is_a($description, 'JXMLElement')) {
			$this->parent->set('message', (string)$description);
		} else {
			$this->parent->set('message', '' );
		}
		
		$element =& $this->manifest->files;

		// Plugin name is specified
		$pname  = (string) $this->manifest->attributes()->plugin;
		
		//Get type
		$type  = $this->manifest->attributes()->group;
		
		if (!empty ($pname)) {
			// ^ Use JCK_PLUGINS defined path
			$this->parent->setPath('extension_root', JCK_PLUGINS . '/'. $pname);
		} else {
			$this->parent->abort('Extension Install: '.JText::_('COM_JCKMAN_ADAPTER_NO_PLUGIN_SPECIFIED'));
			return false;
		}
		/**
		 * ---------------------------------------------------------------------------------------------
		 * Filesystem Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */

		// If the extension directory does not exist, lets create it
		$created = false;
		if (!file_exists($this->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($this->parent->getPath('extension_root'))) {
				$this->parent->abort('Plugin Install: '.JText::_('Failed to create directory').': "'.$this->parent->getPath('extension_root').'"');
				return false;
			}
		}

		/*
		 * If we created the extension directory and will want to remove it if we
		 * have to roll back the installation, lets add it to the installation
		 * step stack
		 */
		if ($created) {
			$this->parent->pushStep(array ('type' => 'folder', 'path' => $this->parent->getPath('extension_root')));
		}

		// Copy all necessary files
		$this->parent->setOverwrite(true);
		if ($this->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Database Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */
		$type = (isset($type) ? (string)$type : 'plugin'); //Add group processimg 
		
		// Check to see if a plugin by the same name is already installed
		// ^ Altered db query for #__JCK_PLUGINS
		$query = 'SELECT id' .
				' FROM #__jckplugins' .
				' WHERE name = '.$db->Quote($pname);
		$db->setQuery($query);
		if (!$db->execute()) {
			// Install failed, roll back changes
			$this->parent->abort('Plugin Install: '.$db->stderr(true));
			return false;
		}
		$id = $db->loadResult();

		// Was there a module already installed with the same name?
		if($id)
		{

			if (!$this->parent->isOverwrite())
			{
				// Install failed, roll back changes
                
				$this->parent->abort(JText::sprintf('COM_JCKMAN_ADAPTER_PLUGIN_ALREADY_EXISTS',$pname));
				return false;
			}

			$row =& JTable::getInstance('plugin', 'JCKTable');
			$row->type = $type;
			$row->load($id);

		}
		else
		{
			$icon 				= $this->manifest->icon;

			// Changes to plugin parameters. Use JCK Plugins Table class. 
			$row =& JTable::getInstance('plugin', 'JCKTable');
			$row->title 		= $this->parent->get('name');
			$row->name			= $pname;
			$row->type 			= $type;
			$row->row	 		= 4;
			$row->published 	= 1;
			$row->editable 		= 1;
			$row->icon 			= ($icon ? (string)$icon : '');
			$row->iscore 		= 0;
			$row->params 		= $this->parent->getParams();

			if($this->manifest->attributes()->parent)
			{
				$parentName = (string) $this->manifest->attributes()->parent;
				$row->setParent($parentName);
			}

			if (!$row->store()) {
				// Install failed, roll back changes
				$this->parent->abort(JText::sprintf('COM_JCKMAN_ADAPTER_PLUGIN_INSTALL',$db->stderr(true)));
				return false;
			}

			// Since we have created a plugin item, we add it to the installation step stack
			// so that if we have to rollback the changes we can undo it.
			$this->parent->pushStep(array ('type' => 'plugin', 'id' => $row->id));
		}

		/* -------------------------------------------------------------------------------------------
		 * update editor plugin config file    AW 
		 * -------------------------------------------------------------------------------------------
		*/ 
		$config = &	JCKHelper::getEditorPluginConfig();

		$config->set($pname,1);
        

		$cfgFile = CKEDITOR_LIBRARY. '/plugins/toolbarplugins.php'; 

		// Get the config registry in PHP class format and write it to configuation.php
		if (!JFile::write($cfgFile, $config->toString('PHP',array('class' => 'JCKToolbarPlugins extends JCKPlugins'))))
		{ 	  
			JCKHelper::error(JText::sprintf('COM_JCKMAN_ADAPTER_FAILED_PUBLISH_PLUGIN',$pname));
		} 	  

	 	/**
		 *-------------------------------------------------------------------------------------------
		 * Add plugin to toolbars
		 *-------------------------------------------------------------------------------------------
		 */
		$CKfolder 	=  CKEDITOR_LIBRARY . '/toolbar'; 
	
		$toolbars 	= JCKHelper::getEditorToolbars();
		$jform		= $app->input->get( 'jform', array(), 'array' );

		switch( $jform['toolbars'] )
		{
			default :
			case 'all' :
				$toolbarnames = $toolbars;
				break;
			case 'none' :
				$toolbarnames = array();
				break;
			case 'select' :
				$toolbarnames = $jform['selections'];
				break;
		}//end switch

   		if(!empty( $toolbarnames) && $row->icon)
		{
	        require_once(CKEDITOR_LIBRARY . '/toolbar.php');   
            $values = array();
			foreach($toolbarnames as $toolbarname)
			{
	               
                $tmpfilename = $CKfolder.'/'.$toolbarname.'.php';

				require($tmpfilename);

				$classname = 'JCK'. ucfirst($toolbarname);

				$toolbar = new $classname();

				$pluginTitle = str_replace(' ','',$row->title);


				if(isset($toolbar->pluginTitle)) continue;

				//fix toolbar values or they will get wiped out
				foreach (get_object_vars( $toolbar ) as $k => $v)
				{

					if(is_null($v))
					{
						$toolbar->$k = ''; 
					}

					if($k[0] == '_')
						$toolbar->$k = NULL;
				}

				$toolbar->$pluginTitle = '';

            

				$toolbarConfig = new JRegistry('toolbar');
				$toolbarConfig->loadObject($toolbar);		

				// Get the config registry in PHP class format and write it to configuation.php
				if (!JFile::write($tmpfilename, $toolbarConfig->toString('PHP', array('class' => $classname . ' extends JCKToolbar'))))
				{ 	  
					JCKHelper::error(JText::sprintf('COM_JCKMAN_ADAPTER_FAILED_TO_ADD_PLUGIN_TOOLBAR',$pname,$classname));
				} 	  

				//layout stuff
				$sql = $db->getQuery( true );
				$sql->select( 'id' )
					->from( '#__jcktoolbars' )
					->where( 'name = "'. $toolbarname .'"' );
				$toolbarid = $db->setQuery( $sql )->loadResult();

				$rowDetail = JCKHelper::getNextLayoutRow($toolbarid);

				$values[] = '('.(int)$toolbarid.','. $row->id.','.$rowDetail->rowid.','.$rowDetail->rowordering.',1)';
			}

			//insert into layout table
			if(!empty($values))
			{
				//Now delete dependencies
				$query = 'DELETE FROM #__jcktoolbarplugins'
					. ' WHERE pluginid ='. $row->id;
				$db->setQuery( $query );
				if (!$db->execute()) {
					JCKHelper::error( $db->getErrorMsg() );
				}

				$query = 'INSERT INTO #__jcktoolbarplugins (toolbarid,pluginid,row,ordering,state) VALUES ' . implode(',',$values);
				$db->setQuery( $query );
				if(!$db->execute()) 
				{
					JCKHelper::error( $db->getErrorMsg() );
				}
			}
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Finalization and Cleanup Section
		 * ---------------------------------------------------------------------------------------------
		 */

		// Lastly, we will copy the manifest file to its appropriate place.
		if (!$this->parent->copyManifest(-1)) {
			// Install failed, rollback changes
			$this->parent->abort('Plugin Install: '.JText::_('Could not copy setup file'));
			return false;
		}

		//make a copy of the plugin
		$src = 	$this->parent->getPath('extension_root');
		$dest = JPATH_ADMINISTRATOR.'/components/com_jckman/editor/plugins/'.$pname;
		
		if (!JFolder::copy( $src, $dest,null,true)) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		return true;
    }

    /**
     * Uninstall method
     *
     * @access  public
     * @param 	string   $name  The name of the plugin to uninstall
     * @return  boolean True on success
     */
    public function uninstall($name) {
		// Initialize variables
		$row	= null;
		$retval = true;
		$db		=& $this->parent->getDBO();

		// First order of business will be to load the module object table from the database.
		// This should give us the necessary information to proceed.
		$sql = 'SELECT id FROM #__jckplugins WHERE name="nge"';
		$db->setQuery($sql);
		$id = $db->loadResult();
		// ^ Changes to plugin parameters. Use JCK Plugins Table class. 
		$row =& JTable::getInstance('plugin', 'JCKTable');
		$row->load((int) $id);

		// Get the plugin folder so we can properly build the plugin path
		if (trim($row->name) == '') {
			JCKHelper::error( JText::_('COM_JCKMAN_ADAPTER_PLUGIN_FIELD_EMPTY'));
			return false;
		}

		//Now delete dependencies
		$sql = $db->getQuery( true );
		$sql->delete( '#__jcktoolbarplugins' )
			->where( 'pluginid ='. $row->id );

		if (!$db->setQuery( $sql )->execute())
		{
			JCKHelper::error( $db->getErrorMsg() );
		}

		// Set the plugin root path
		$this->parent->setPath('extension_root', JCK_PLUGINS . '/' . $row->name);

		$manifestFile = $this->parent->getPath('extension_root') . '/' . $row->name . '.xml';

		if (file_exists($manifestFile))
		{
			// If we cannot load the xml file return null
			if (!($xml = JFactory::getXML($manifestFile))) {
				JCKHelper::error(JText::_('COM_JCKMAN_ADAPTER_UNINSTALL_COULD_NOT_LOAD_MANIFEST'));
				return false;
			}

			$pname = (string) $xml->attributes()->plugin;
			
			
			/**  
			 *
			 * Remove plugin from toolbars file  AW
			 *
			 */
			$CKfolder =  CKEDITOR_LIBRARY . '/toolbar'; 

			$toolbarnames =& JCKHelper::getEditorToolbars();

			foreach($toolbarnames as $toolbarname)
			{
				require_once(CKEDITOR_LIBRARY.'/toolbar.php');  
				$tmpfilename = $CKfolder.'/'.$toolbarname.'.php';

				require_once($tmpfilename);

				$classname 	= 'JCK'. ucfirst($toolbarname);
				$toolbar 	= new $classname();

				$pluginTitle =  str_replace(' ','',$row->title);
				$pluginTitle = ucfirst($pluginTitle);
				if(!isset($toolbar->$pluginTitle)) continue;
				//fix toolbar values or they will get wiped out

				foreach (get_object_vars( $toolbar ) as $k => $v)
				{
					if(is_null($v))
					{
						$toolbar->$k = ''; 
					}

					if($k[0] == '_')
					$toolbar->$k = NULL;
				}

				$toolbar->$pluginTitle = NULL;

				$toolbarConfig = new JRegistry('toolbar');

				$toolbarConfig->loadObject($toolbar);		

				// Get the config registry in PHP class format and write it to configuation.php
				if (!JFile::write($tmpfilename, $toolbarConfig->toString('PHP', array('class' => $classname . ' extends JCKToolbar'))))
				{
					JCKHelper::error(	JText::sprintf('COM_JCKMAN_ADAPTER_FAILED_TO_REMOVE_PLUGIN_TOOLBAR',$row->name,$classname));
				}
			}

			 /**
			  *
			  * Remove plugin from config file  AW
			  *
			  */
			$config = &	JCKHelper::getEditorPluginConfig();

			$config->set($row->name,NULL); // remove value from output

			$cfgFile = CKEDITOR_LIBRARY . '/plugins/toolbarplugins.php'; 

			// Get the config registry in PHP class format and write it to configuation.php
			if (!JFile::write($cfgFile, $config->toString('PHP', array('class' => 'JCKToolbarPlugins extends JCKPlugins'))))
			{
				JCKHelper::error(JText::sprintf('COM_JCKMAN_ADAPTER_FAILED_TO_REMOVE_PLUGIN_FROM_CONFIG',$pname));
			}

			$root =& $xml;

			if ($root->getName() != 'extension' && $root->getName() != 'install') {
				JCKHelper::error( JText::_('COM_JCKMAN_ADAPTER_UNINSTALL_INVALID_MANIFEST'));
				return false;
			}

			// Remove the plugin files
			$this->parent->removeFiles($root->files, -1);
			JFile::delete($manifestFile);

			// Remove all media and languages as well
			$this->parent->removeFiles($root->languages, 0);

		} else {
			JCKHelper::error( Jtext::_('COM_JCKMAN_ADAPTER_UNINSTALL_INVALID_MANIFEST_OR_NOT_FOUND'));

			$row->delete($row->id);
			unset ($row);
			$retval = false;
		}

		if( $row )
		{
			// Now we will no longer need the plugin object, so lets delete it
			$row->delete($row->id);
			unset ($row);
		}

		// If the folder is empty, let's delete it
		$files = JFolder::files($this->parent->getPath('extension_root'));
		if (!count($files)) {
			JFolder::delete($this->parent->getPath('extension_root'));
		}

		//Now delete copy of plugin stored in the component
		$copyPath = JPATH_ADMINISTRATOR.'/components/com_jckman/editor/plugins/'.$pname;
		JFolder::delete($copyPath);

        // delete record in nge_plugins
        $sql = "DELETE FROM #__nge_plugins WHERE name='$name'";
        $db->setQuery($sql);
        $db->execute();

		return $retval;

    }


}
