<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/datatablenavigationpaging.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/datatablenavigationsearching.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/datatablenavigationordering.php');

/**
 * Table Navigation class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDatatableNavigation{
	
	/**
	 * @var String $style
	 */
	public $style;
    
	/**
	 * @var PartTableNavigationPaging $paging
	 */
	public $paging;
	
	/**   
	 * @var PartTableNavigationSearching $searching
	 */
	public $searching;
	
	/**   
	 * @var PartTableNavigationOrdering $ordering
	 */
	public $ordering;
	
	/**   
	 * @var String $resizing
	 */
	public $resizing;
	
	/**
	 * @var String $info
	 */
	public $info;
		
	function __construct(){		
		$this->style 		= 'default';
		$this->paging 		= new PartDatatableNavigationPaging();
		$this->searching 		= new PartDatatableNavigationSearching();
		$this->ordering 		= new PartDatatableNavigationOrdering();
		$this->resizing 	= '0';
		$this->info 	= '0';
	}
	
	public function bind($data){
		if(isset($data->style))	$this->style 	= $data->style;
		if(isset($data->paging))	$this->paging->bind($data->paging);
		if(isset($data->searching))	$this->searching->bind($data->searching);
		if(isset($data->ordering))	$this->ordering->bind($data->ordering);
		if(isset($data->resizing))	$this->resizing 	= $data->resizing;
		if(isset($data->info))		$this->info 	= $data->info;
	}
	
	public function codeWizard($partObject){}
}
